/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.jdbc.IoTDBConnectionParams;
import org.apache.iotdb.jdbc.IoTDBURLException;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class Utils {
    static IoTDBConnectionParams parseUrl(String url, Properties info) throws IoTDBURLException {
        String subURL;
        IoTDBConnectionParams params = new IoTDBConnectionParams(url);
        if (url.trim().equalsIgnoreCase("jdbc:iotdb://")) {
            return params;
        }
        boolean isUrlLegal = false;
        Pattern pattern = Pattern.compile("^(((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}|localhost|(([0-9]{1,3}\\.){3})[0-9]{1,3}):[0-9]{1,5}/?$");
        Matcher matcher = pattern.matcher(subURL = url.substring("jdbc:iotdb://".length()));
        if (matcher.matches()) {
            isUrlLegal = true;
        }
        String[] DomainAndPort = subURL.contains("/") ? subURL.substring(0, subURL.length() - 1).split(":") : subURL.split(":");
        params.setHost(DomainAndPort[0]);
        params.setPort(Integer.parseInt(DomainAndPort[1]));
        if (!isUrlLegal) {
            throw new IoTDBURLException("Error url format, url should be jdbc:iotdb://domain|ip:port/ or jdbc:iotdb://domain|ip:port");
        }
        if (info.containsKey("user")) {
            params.setUsername(info.getProperty("user"));
        }
        if (info.containsKey("password")) {
            params.setPassword(info.getProperty("password"));
        }
        return params;
    }

    static List<RowRecord> convertRowRecords(TSQueryDataSet tsQueryDataSet, List<String> columnTypeList) {
        int rowCount = tsQueryDataSet.getRowCount();
        ByteBuffer byteBuffer = tsQueryDataSet.bufferForValues();
        List<RowRecord> rowRecordList = Utils.processTimeAndCreateRowRecords(byteBuffer, rowCount);
        for (String type : columnTypeList) {
            for (int i = 0; i < rowCount; ++i) {
                Field field = null;
                boolean is_empty = BytesUtils.byteToBool((byte)byteBuffer.get());
                if (is_empty) {
                    field = new Field(null);
                } else {
                    TSDataType dataType = TSDataType.valueOf((String)type);
                    field = new Field(dataType);
                    switch (dataType) {
                        case BOOLEAN: {
                            boolean booleanValue = BytesUtils.byteToBool((byte)byteBuffer.get());
                            field.setBoolV(booleanValue);
                            break;
                        }
                        case INT32: {
                            int intValue = byteBuffer.getInt();
                            field.setIntV(intValue);
                            break;
                        }
                        case INT64: {
                            long longValue = byteBuffer.getLong();
                            field.setLongV(longValue);
                            break;
                        }
                        case FLOAT: {
                            float floatValue = byteBuffer.getFloat();
                            field.setFloatV(floatValue);
                            break;
                        }
                        case DOUBLE: {
                            double doubleValue = byteBuffer.getDouble();
                            field.setDoubleV(doubleValue);
                            break;
                        }
                        case TEXT: {
                            int binarySize = byteBuffer.getInt();
                            byte[] binaryValue = new byte[binarySize];
                            byteBuffer.get(binaryValue);
                            field.setBinaryV(new Binary(binaryValue));
                            break;
                        }
                        default: {
                            throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                        }
                    }
                }
                rowRecordList.get(i).getFields().add(field);
            }
        }
        return rowRecordList;
    }

    private static List<RowRecord> processTimeAndCreateRowRecords(ByteBuffer byteBuffer, int rowCount) {
        ArrayList<RowRecord> rowRecordList = new ArrayList<RowRecord>();
        for (int i = 0; i < rowCount; ++i) {
            long timestamp = byteBuffer.getLong();
            RowRecord rowRecord = new RowRecord(timestamp);
            rowRecordList.add(rowRecord);
        }
        return rowRecordList;
    }
}

