/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.iotdb.tsfile.compress.ICompressor;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkBuffer.class);
    private ICompressor compressor;
    private MeasurementSchema schema;
    private int numOfPages;
    private PublicBAOS pageBuffer;
    private long totalValueCount;
    private long maxTimestamp;
    private long minTimestamp = Long.MIN_VALUE;
    private ByteBuffer compressedData;

    public ChunkBuffer(MeasurementSchema schema) {
        this.schema = schema;
        this.compressor = ICompressor.getCompressor(schema.getCompressor());
        this.pageBuffer = new PublicBAOS();
    }

    public int getNumOfPages() {
        return this.numOfPages;
    }

    public int writePageHeaderAndDataIntoBuff(ByteBuffer data, int valueCount, Statistics<?> statistics, long maxTimestamp, long minTimestamp) throws PageException {
        int headerSize;
        int compressedSize;
        ++this.numOfPages;
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = minTimestamp;
        }
        if (this.minTimestamp == Long.MIN_VALUE) {
            throw new PageException("No valid data point in this page");
        }
        this.maxTimestamp = maxTimestamp;
        int uncompressedSize = data.remaining();
        int compressedPosition = 0;
        byte[] compressedBytes = null;
        if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
            compressedSize = data.remaining();
        } else {
            compressedBytes = new byte[this.compressor.getMaxBytesForCompression(uncompressedSize)];
            try {
                compressedPosition = 0;
                compressedSize = this.compressor.compress(data.array(), data.position(), data.remaining(), compressedBytes);
            }
            catch (IOException e) {
                throw new PageException(e);
            }
        }
        try {
            PageHeader header = new PageHeader(uncompressedSize, compressedSize, valueCount, statistics, maxTimestamp, minTimestamp);
            headerSize = header.getSerializedSize();
            LOG.debug("start to flush a page header into buffer, buffer position {} ", (Object)this.pageBuffer.size());
            header.serializeTo(this.pageBuffer);
            LOG.debug("finish to flush a page header {} of {} into buffer, buffer position {} ", new Object[]{header, this.schema.getMeasurementId(), this.pageBuffer.size()});
        }
        catch (IOException e) {
            this.resetTimeStamp();
            throw new PageException("IO Exception in writeDataPageHeader,ignore this page", e);
        }
        this.totalValueCount += (long)valueCount;
        try (WritableByteChannel channel = Channels.newChannel(this.pageBuffer);){
            LOG.debug("start to flush a page data into buffer, buffer position {} ", (Object)this.pageBuffer.size());
            if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
                channel.write(data);
            } else if (data.isDirect()) {
                channel.write(this.compressedData);
            } else {
                this.pageBuffer.write(compressedBytes, compressedPosition, compressedSize);
            }
            LOG.debug("start to flush a page data into buffer, buffer position {} ", (Object)this.pageBuffer.size());
        }
        catch (IOException e) {
            throw new PageException(e);
        }
        return headerSize + uncompressedSize;
    }

    public void writePageHeaderAndDataIntoBuff(ByteBuffer data, PageHeader header) throws PageException {
        ++this.numOfPages;
        if (this.minTimestamp == Long.MIN_VALUE) {
            this.minTimestamp = header.getMinTimestamp();
        }
        if (this.minTimestamp == Long.MIN_VALUE) {
            throw new PageException("No valid data point in this page");
        }
        this.maxTimestamp = header.getMaxTimestamp();
        try {
            LOG.debug("start to flush a page header into buffer, buffer position {} ", (Object)this.pageBuffer.size());
            header.serializeTo(this.pageBuffer);
            LOG.debug("finish to flush a page header {} of {} into buffer, buffer position {} ", new Object[]{header, this.schema.getMeasurementId(), this.pageBuffer.size()});
        }
        catch (IOException e) {
            this.resetTimeStamp();
            throw new PageException("IO Exception in writeDataPageHeader,ignore this page", e);
        }
        this.totalValueCount += (long)header.getNumOfValues();
        try (WritableByteChannel channel = Channels.newChannel(this.pageBuffer);){
            channel.write(data);
        }
        catch (IOException e) {
            throw new PageException(e);
        }
    }

    private void resetTimeStamp() {
        if (this.totalValueCount == 0L) {
            this.minTimestamp = Long.MIN_VALUE;
        }
    }

    public long writeAllPagesOfSeriesToTsFile(TsFileIOWriter writer, Statistics<?> statistics) throws IOException {
        if (this.totalValueCount == 0L) {
            return 0L;
        }
        int headerSize = writer.startFlushChunk(this.schema, this.compressor.getType(), this.schema.getType(), this.schema.getEncodingType(), statistics, this.maxTimestamp, this.minTimestamp, this.pageBuffer.size(), this.numOfPages);
        long dataOffset = writer.getPos();
        LOG.debug("start writing pages of {} into file, position {}", (Object)this.schema.getMeasurementId(), (Object)writer.getPos());
        writer.writeBytesToStream(this.pageBuffer);
        LOG.debug("finish writing pages of {} into file, position {}", (Object)this.schema.getMeasurementId(), (Object)writer.getPos());
        long dataSize = writer.getPos() - dataOffset;
        if (dataSize != (long)this.pageBuffer.size()) {
            throw new IOException("Bytes written is inconsistent with the size of data: " + dataSize + " != " + this.pageBuffer.size());
        }
        writer.endChunk(this.totalValueCount);
        return (long)headerSize + dataSize;
    }

    public void reset() {
        this.minTimestamp = Long.MIN_VALUE;
        this.pageBuffer.reset();
        this.totalValueCount = 0L;
    }

    public void reInit(MeasurementSchema schema) {
        this.reset();
        this.schema = schema;
        this.compressor = ICompressor.getCompressor(schema.getCompressor());
        this.numOfPages = 0;
        this.maxTimestamp = 0L;
    }

    public long estimateMaxPageMemSize() {
        return this.pageBuffer.size() + this.estimateMaxPageHeaderSize();
    }

    private int estimateMaxPageHeaderSize() {
        return PageHeader.calculatePageHeaderSize(this.schema.getType());
    }

    public long getCurrentDataSize() {
        return this.pageBuffer.size();
    }

    public void setSchema(MeasurementSchema schema) {
        this.schema = schema;
    }

    public MeasurementSchema getSchema() {
        return this.schema;
    }
}

