/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.tool.upgrade;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.tsfile.compress.ICompressor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.exception.compress.CompressionTypeNotSupportedException;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.footer.ChunkGroupFooter;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsDigest;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.reader.DefaultTsFileInput;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.chunk.ChunkBuffer;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsfileUpgradeToolV0_8_0
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TsfileUpgradeToolV0_8_0.class);
    private TsFileInput tsFileInput;
    private long fileMetadataPos;
    private int fileMetadataSize;
    private ByteBuffer markerBuffer = ByteBuffer.allocate(1);
    protected String file;

    public TsfileUpgradeToolV0_8_0(String file) throws IOException {
        this(file, true);
    }

    public TsfileUpgradeToolV0_8_0(String file, boolean loadMetadataSize) throws IOException {
        this.file = file;
        Path path = Paths.get(file, new String[0]);
        this.tsFileInput = new DefaultTsFileInput(path);
        try {
            if (loadMetadataSize) {
                this.loadMetadataSize(false);
            }
        }
        catch (Throwable e) {
            this.tsFileInput.close();
            throw e;
        }
    }

    public void loadMetadataSize(boolean sealedWithNewMagic) throws IOException {
        ByteBuffer metadataSize = ByteBuffer.allocate(4);
        if (sealedWithNewMagic) {
            this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L);
            metadataSize.flip();
            this.fileMetadataSize = ReadWriteIOUtils.readInt(metadataSize);
            this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFile".getBytes().length - 4L - (long)this.fileMetadataSize;
        } else {
            this.tsFileInput.read(metadataSize, this.tsFileInput.size() - (long)"TsFilev0.8.0".length() - 4L);
            metadataSize.flip();
            this.fileMetadataSize = ReadWriteIOUtils.readInt(metadataSize);
            this.fileMetadataPos = this.tsFileInput.size() - (long)"TsFilev0.8.0".length() - 4L - (long)this.fileMetadataSize;
        }
        this.position("TsFilev0.8.0".length());
    }

    public String readTailMagic() throws IOException {
        long totalSize = this.tsFileInput.size();
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFilev0.8.0".length());
        this.tsFileInput.read(magicStringBytes, totalSize - (long)"TsFilev0.8.0".length());
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public boolean isComplete() throws IOException {
        return this.tsFileInput.size() >= (long)("TsFilev0.8.0".length() * 2) && this.readTailMagic().equals(this.readHeadMagic());
    }

    public String readHeadMagic() throws IOException {
        return this.readHeadMagic(false);
    }

    public String readHeadMagic(boolean movePosition) throws IOException {
        ByteBuffer magicStringBytes = ByteBuffer.allocate("TsFilev0.8.0".length());
        if (movePosition) {
            this.tsFileInput.position(0L);
            this.tsFileInput.read(magicStringBytes);
        } else {
            this.tsFileInput.read(magicStringBytes, 0L);
        }
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    public TsFileMetaData readFileMetadata() throws IOException {
        ByteBuffer buffer = this.readData(this.fileMetadataPos, this.fileMetadataSize);
        TsFileMetaData fileMetaData = new TsFileMetaData();
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            HashMap<String, TsDeviceMetadataIndex> deviceMap = new HashMap<String, TsDeviceMetadataIndex>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                TsDeviceMetadataIndex value = TsDeviceMetadataIndex.deserializeFrom(buffer);
                deviceMap.put(key, value);
            }
            fileMetaData.setDeviceIndexMap(deviceMap);
        }
        if ((size = ReadWriteIOUtils.readInt(buffer)) > 0) {
            fileMetaData.setMeasurementSchema(new HashMap<String, MeasurementSchema>());
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                MeasurementSchema value = MeasurementSchema.deserializeFrom(buffer);
                fileMetaData.getMeasurementSchema().put(key, value);
            }
        }
        ReadWriteIOUtils.readInt(buffer);
        if (ReadWriteIOUtils.readIsNull(buffer)) {
            fileMetaData.setCreatedBy(ReadWriteIOUtils.readString(buffer));
        }
        return fileMetaData;
    }

    public TsDeviceMetadata readTsDeviceMetaData(TsDeviceMetadataIndex index) throws IOException {
        return TsDeviceMetadata.deserializeFrom(this.readData(index.getOffset(), index.getLen()));
    }

    public ChunkGroupFooter readChunkGroupFooter() throws IOException {
        return ChunkGroupFooter.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    public ChunkHeader readChunkHeader() throws IOException {
        return ChunkHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), true);
    }

    public PageHeader readPageHeader(TSDataType type) throws IOException {
        return PageHeader.deserializeFrom(this.tsFileInput.wrapAsInputStream(), type);
    }

    public long position() throws IOException {
        return this.tsFileInput.position();
    }

    public void position(long offset) throws IOException {
        this.tsFileInput.position(offset);
    }

    public byte readMarker() throws IOException {
        this.markerBuffer.clear();
        if (ReadWriteIOUtils.readAsPossible(this.tsFileInput, this.markerBuffer) == 0) {
            throw new IOException("reach the end of the file.");
        }
        this.markerBuffer.flip();
        return this.markerBuffer.get();
    }

    @Override
    public void close() throws IOException {
        this.tsFileInput.close();
    }

    public String getFileName() {
        return this.file;
    }

    private ByteBuffer readData(long position, int size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        if (position == -1L ? ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer) != size : ReadWriteIOUtils.readAsPossible(this.tsFileInput, buffer, position, size) != size) {
            throw new IOException("reach the end of the data");
        }
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upgradeFile(String updateFileName) throws IOException {
        TsFileMetaData tsFileMetaData;
        File checkFile = FSFactoryProducer.getFSFactory().getFile(this.file);
        if (!checkFile.exists()) {
            logger.error("the file to be updated does not exist, file path: {}", (Object)checkFile.getPath());
            return false;
        }
        long fileSize = checkFile.length();
        File upgradeFile = FSFactoryProducer.getFSFactory().getFile(updateFileName);
        if (!upgradeFile.getParentFile().exists()) {
            upgradeFile.getParentFile().mkdirs();
        }
        upgradeFile.createNewFile();
        TsFileIOWriter tsFileIOWriter = new TsFileIOWriter(upgradeFile);
        ArrayList<ChunkHeader> chunkHeaders = new ArrayList<ChunkHeader>();
        ArrayList pageHeadersList = new ArrayList();
        ArrayList pagesList = new ArrayList();
        Schema schema = null;
        String magic = this.readHeadMagic(true);
        if (!magic.equals("TsFilev0.8.0")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)checkFile.getPath());
            return false;
        }
        if (fileSize == (long)"TsFilev0.8.0".length()) {
            logger.error("the file only contains magic string, file path: {}", (Object)checkFile.getPath());
            return false;
        }
        if (this.readTailMagic().equals("TsFilev0.8.0")) {
            this.loadMetadataSize(false);
            tsFileMetaData = this.readFileMetadata();
            schema = new Schema(tsFileMetaData.getMeasurementSchema());
        } else {
            this.loadMetadataSize(true);
            tsFileMetaData = this.readFileMetadata();
            schema = new Schema(tsFileMetaData.getMeasurementSchema());
        }
        long startTimeOfChunk = 0L;
        long endTimeOfChunk = 0L;
        long numOfPoints = 0L;
        ArrayList<ChunkMetaData> chunkMetaDataList = null;
        long startOffsetOfChunkGroup = 0L;
        boolean newChunkGroup = true;
        long versionOfChunkGroup = 0L;
        ArrayList<ChunkGroupMetaData> newMetaData = new ArrayList<ChunkGroupMetaData>();
        ArrayList chunkStatisticsList = new ArrayList();
        boolean goon = true;
        try {
            byte marker;
            block10: while (goon && (marker = this.readMarker()) != 2) {
                switch (marker) {
                    case 1: {
                        if (newChunkGroup) {
                            newChunkGroup = false;
                            chunkMetaDataList = new ArrayList<ChunkMetaData>();
                            startOffsetOfChunkGroup = this.position() - 1L;
                        }
                        long fileOffsetOfChunk = this.position() - 1L;
                        ChunkHeader header = this.readChunkHeader();
                        chunkHeaders.add(header);
                        ArrayList<PageHeader> pageHeaders = new ArrayList<PageHeader>();
                        ArrayList<ByteBuffer> pages = new ArrayList<ByteBuffer>();
                        TSDataType dataType = header.getDataType();
                        Statistics<?> chunkStatistics = Statistics.getStatsByType(dataType);
                        chunkStatisticsList.add(chunkStatistics);
                        if (header.getNumOfPages() > 0) {
                            PageHeader pageHeader = this.readPageHeader(header.getDataType());
                            pageHeaders.add(pageHeader);
                            numOfPoints += (long)pageHeader.getNumOfValues();
                            startTimeOfChunk = pageHeader.getMinTimestamp();
                            endTimeOfChunk = pageHeader.getMaxTimestamp();
                            chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                            pages.add(this.readData(-1L, pageHeader.getCompressedSize()));
                        }
                        for (int j = 1; j < header.getNumOfPages() - 1; ++j) {
                            PageHeader pageHeader = this.readPageHeader(header.getDataType());
                            pageHeaders.add(pageHeader);
                            numOfPoints += (long)pageHeader.getNumOfValues();
                            chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                            pages.add(this.readData(-1L, pageHeader.getCompressedSize()));
                        }
                        if (header.getNumOfPages() > 1) {
                            PageHeader pageHeader = this.readPageHeader(header.getDataType());
                            pageHeaders.add(pageHeader);
                            numOfPoints += (long)pageHeader.getNumOfValues();
                            endTimeOfChunk = pageHeader.getMaxTimestamp();
                            chunkStatistics.mergeStatistics(pageHeader.getStatistics());
                            pages.add(this.readData(-1L, pageHeader.getCompressedSize()));
                        }
                        ChunkMetaData currentChunkMetaData = new ChunkMetaData(header.getMeasurementID(), dataType, fileOffsetOfChunk, startTimeOfChunk, endTimeOfChunk);
                        currentChunkMetaData.setNumOfPoints(numOfPoints);
                        ByteBuffer[] statisticsArray = new ByteBuffer[TsDigest.StatisticType.getTotalTypeNum()];
                        statisticsArray[TsDigest.StatisticType.min_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getMinBytes());
                        statisticsArray[TsDigest.StatisticType.max_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getMaxBytes());
                        statisticsArray[TsDigest.StatisticType.first_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getFirstBytes());
                        statisticsArray[TsDigest.StatisticType.last_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getLastBytes());
                        statisticsArray[TsDigest.StatisticType.sum_value.ordinal()] = ByteBuffer.wrap(chunkStatistics.getSumBytes());
                        TsDigest tsDigest = new TsDigest();
                        tsDigest.setStatistics(statisticsArray);
                        currentChunkMetaData.setDigest(tsDigest);
                        chunkMetaDataList.add(currentChunkMetaData);
                        numOfPoints = 0L;
                        pageHeadersList.add(pageHeaders);
                        pagesList.add(pages);
                        continue block10;
                    }
                    case 0: {
                        ChunkGroupFooter chunkGroupFooter = this.readChunkGroupFooter();
                        String deviceID = chunkGroupFooter.getDeviceID();
                        long endOffsetOfChunkGroup = this.position();
                        ChunkGroupMetaData currentChunkGroup = new ChunkGroupMetaData(deviceID, chunkMetaDataList, startOffsetOfChunkGroup);
                        currentChunkGroup.setEndOffsetOfChunkGroup(endOffsetOfChunkGroup);
                        currentChunkGroup.setVersion(versionOfChunkGroup++);
                        newMetaData.add(currentChunkGroup);
                        tsFileIOWriter.startChunkGroup(deviceID);
                        for (int i = 0; i < chunkHeaders.size(); ++i) {
                            TSDataType tsDataType = ((ChunkHeader)chunkHeaders.get(i)).getDataType();
                            TSEncoding encodingType = ((ChunkHeader)chunkHeaders.get(i)).getEncodingType();
                            CompressionType compressionType = ((ChunkHeader)chunkHeaders.get(i)).getCompressionType();
                            ChunkHeader chunkHeader = (ChunkHeader)chunkHeaders.get(i);
                            List pageHeaderList = (List)pageHeadersList.get(i);
                            List pageList = (List)pagesList.get(i);
                            if (schema.getMeasurementSchema(chunkHeader.getMeasurementID()) == null) continue;
                            ChunkBuffer chunkBuffer = new ChunkBuffer(schema.getMeasurementSchema(chunkHeader.getMeasurementID()));
                            for (int j = 0; j < pageHeaderList.size(); ++j) {
                                if (encodingType.equals((Object)TSEncoding.PLAIN)) {
                                    pageList.set(j, TsfileUpgradeToolV0_8_0.rewrite((ByteBuffer)pageList.get(j), tsDataType, compressionType, (PageHeader)pageHeaderList.get(j)));
                                }
                                chunkBuffer.writePageHeaderAndDataIntoBuff((ByteBuffer)pageList.get(j), (PageHeader)pageHeaderList.get(j));
                            }
                            chunkBuffer.writeAllPagesOfSeriesToTsFile(tsFileIOWriter, (Statistics)chunkStatisticsList.get(i));
                        }
                        tsFileIOWriter.endChunkGroup(currentChunkGroup.getVersion());
                        chunkStatisticsList.clear();
                        chunkHeaders.clear();
                        pageHeadersList.clear();
                        pagesList.clear();
                        newChunkGroup = true;
                        continue block10;
                    }
                }
                logger.error("Unrecognized marker detected, this file may be corrupted");
                boolean bl = false;
                return bl;
            }
            tsFileIOWriter.endFile(schema);
            boolean fileOffsetOfChunk = true;
            return fileOffsetOfChunk;
        }
        catch (IOException | PageException e2) {
            logger.info("TsFile upgrade process cannot proceed at position {} after {} chunk groups recovered, because : {}", new Object[]{this.position(), newMetaData.size(), e2.getMessage()});
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.tsFileInput != null) {
                this.tsFileInput.close();
            }
            if (tsFileIOWriter != null) {
                tsFileIOWriter.close();
            }
        }
    }

    static ByteBuffer rewrite(ByteBuffer page, TSDataType tsDataType, CompressionType compressionType, PageHeader pageHeader) {
        switch (compressionType) {
            case UNCOMPRESSED: {
                break;
            }
            case SNAPPY: {
                IUnCompressor.SnappyUnCompressor snappyUnCompressor = new IUnCompressor.SnappyUnCompressor();
                page = ByteBuffer.wrap(snappyUnCompressor.uncompress(page.array()));
                break;
            }
            default: {
                throw new CompressionTypeNotSupportedException(compressionType.toString());
            }
        }
        ByteBuffer modifiedPage = ByteBuffer.allocate(page.capacity());
        int timeBufferLength = ReadWriteForEncodingUtils.readUnsignedVarInt(page);
        ByteBuffer timeBuffer = page.slice();
        ByteBuffer valueBuffer = page.slice();
        timeBuffer.limit(timeBufferLength);
        valueBuffer.position(timeBufferLength);
        valueBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(timeBufferLength, modifiedPage);
        modifiedPage.put(timeBuffer);
        modifiedPage.order(ByteOrder.BIG_ENDIAN);
        switch (tsDataType) {
            case BOOLEAN: {
                modifiedPage.put(valueBuffer);
                break;
            }
            case INT32: {
                while (valueBuffer.remaining() > 0) {
                    modifiedPage.putInt(valueBuffer.getInt());
                }
                break;
            }
            case INT64: {
                while (valueBuffer.remaining() > 0) {
                    modifiedPage.putLong(valueBuffer.getLong());
                }
                break;
            }
            case FLOAT: {
                while (valueBuffer.remaining() > 0) {
                    modifiedPage.putFloat(valueBuffer.getFloat());
                }
                break;
            }
            case DOUBLE: {
                while (valueBuffer.remaining() > 0) {
                    modifiedPage.putDouble(valueBuffer.getDouble());
                }
                break;
            }
            case TEXT: {
                while (valueBuffer.remaining() > 0) {
                    int length = valueBuffer.getInt();
                    byte[] buf = new byte[length];
                    valueBuffer.get(buf, 0, buf.length);
                    modifiedPage.putInt(length);
                    modifiedPage.put(buf);
                }
                break;
            }
        }
        switch (compressionType) {
            case UNCOMPRESSED: {
                modifiedPage.flip();
                break;
            }
            case SNAPPY: {
                pageHeader.setUncompressedSize(modifiedPage.array().length);
                ICompressor.SnappyCompressor snappyCompressor = new ICompressor.SnappyCompressor();
                try {
                    modifiedPage = ByteBuffer.wrap(snappyCompressor.compress(modifiedPage.array()));
                    pageHeader.setCompressedSize(modifiedPage.array().length);
                }
                catch (IOException e) {
                    logger.error("failed to compress page as snappy", (Throwable)e);
                }
                break;
            }
            default: {
                throw new CompressionTypeNotSupportedException(compressionType.toString());
            }
        }
        return modifiedPage;
    }
}

