/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.common.EndianType;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;

public abstract class ChunkReader {
    ChunkHeader chunkHeader;
    private ByteBuffer chunkDataBuffer;
    private IUnCompressor unCompressor;
    private EndianType endianType;
    private Decoder valueDecoder;
    private Decoder timeDecoder = Decoder.getDecoderByType(TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), TSDataType.INT64);
    private Filter filter;
    private BatchData data;
    private PageHeader pageHeader;
    private boolean hasCachedPageHeader;
    protected long deletedAt;

    public ChunkReader(Chunk chunk) {
        this(chunk, null);
    }

    public ChunkReader(Chunk chunk, Filter filter) {
        this.filter = filter;
        this.chunkDataBuffer = chunk.getData();
        this.deletedAt = chunk.getDeletedAt();
        this.endianType = chunk.getEndianType();
        this.chunkHeader = chunk.getHeader();
        this.unCompressor = IUnCompressor.getUnCompressor(this.chunkHeader.getCompressionType());
        this.valueDecoder = Decoder.getDecoderByType(this.chunkHeader.getEncodingType(), this.chunkHeader.getDataType());
        this.valueDecoder.setEndianType(this.endianType);
        this.data = new BatchData(this.chunkHeader.getDataType());
        this.hasCachedPageHeader = false;
    }

    public boolean hasNextBatch() throws IOException {
        if (this.hasCachedPageHeader) {
            return true;
        }
        while (this.chunkDataBuffer.remaining() > 0) {
            this.pageHeader = PageHeader.deserializeFrom(this.chunkDataBuffer, this.chunkHeader.getDataType());
            if (this.pageSatisfied(this.pageHeader)) {
                this.hasCachedPageHeader = true;
                return true;
            }
            this.skipBytesInStreamByLength(this.pageHeader.getCompressedSize());
        }
        return false;
    }

    public BatchData nextBatch() throws IOException {
        PageReader pageReader = this.constructPageReaderForNextPage(this.pageHeader.getCompressedSize());
        this.hasCachedPageHeader = false;
        if (pageReader.hasNextBatch()) {
            this.data = pageReader.nextBatch();
            return this.data;
        }
        return this.data;
    }

    public BatchData currentBatch() {
        return this.data;
    }

    public PageHeader nextPageHeader() throws IOException {
        return this.pageHeader;
    }

    public void skipPageData() {
        this.skipBytesInStreamByLength(this.pageHeader.getCompressedSize());
        this.hasCachedPageHeader = false;
    }

    private void skipBytesInStreamByLength(long length) {
        this.chunkDataBuffer.position(this.chunkDataBuffer.position() + (int)length);
    }

    public abstract boolean pageSatisfied(PageHeader var1);

    private PageReader constructPageReaderForNextPage(int compressedPageBodyLength) throws IOException {
        byte[] compressedPageBody = new byte[compressedPageBodyLength];
        if (compressedPageBodyLength > this.chunkDataBuffer.remaining()) {
            throw new IOException("unexpected byte read length when read compressedPageBody. Expected:" + Arrays.toString(compressedPageBody) + ". Actual:" + this.chunkDataBuffer.remaining());
        }
        this.chunkDataBuffer.get(compressedPageBody, 0, compressedPageBodyLength);
        this.valueDecoder.reset();
        ByteBuffer pageData = ByteBuffer.wrap(this.unCompressor.uncompress(compressedPageBody));
        PageReader reader = new PageReader(pageData, this.chunkHeader.getDataType(), this.valueDecoder, this.timeDecoder, this.filter);
        reader.setDeletedAt(this.deletedAt);
        return reader;
    }

    public void close() {
    }

    public ChunkHeader getChunkHeader() {
        return this.chunkHeader;
    }
}

