/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReader;

public class DataSetWithoutTimeGenerator
extends QueryDataSet {
    private List<FileSeriesReader> readers;
    private List<BatchData> batchDataList;
    private List<Boolean> hasDataRemaining;
    private PriorityQueue<Long> timeHeap;
    private Set<Long> timeSet;

    public DataSetWithoutTimeGenerator(List<Path> paths, List<TSDataType> dataTypes, List<FileSeriesReader> readers) throws IOException {
        super(paths, dataTypes);
        this.readers = readers;
        this.initHeap();
    }

    private void initHeap() throws IOException {
        this.hasDataRemaining = new ArrayList<Boolean>();
        this.batchDataList = new ArrayList<BatchData>();
        this.timeHeap = new PriorityQueue();
        this.timeSet = new HashSet<Long>();
        for (int i = 0; i < this.paths.size(); ++i) {
            FileSeriesReader reader = this.readers.get(i);
            if (!reader.hasNextBatch()) {
                this.batchDataList.add(new BatchData());
                this.hasDataRemaining.add(false);
                continue;
            }
            this.batchDataList.add(reader.nextBatch());
            this.hasDataRemaining.add(true);
        }
        for (BatchData data : this.batchDataList) {
            if (!data.hasNext()) continue;
            this.timeHeapPut(data.currentTime());
        }
    }

    @Override
    public boolean hasNext() {
        return this.timeHeap.size() > 0;
    }

    @Override
    public RowRecord next() throws IOException {
        long minTime = this.timeHeapGet();
        RowRecord record = new RowRecord(minTime);
        for (int i = 0; i < this.paths.size(); ++i) {
            Field field = new Field((TSDataType)((Object)this.dataTypes.get(i)));
            if (!this.hasDataRemaining.get(i).booleanValue()) {
                record.addField(new Field(null));
                continue;
            }
            BatchData data = this.batchDataList.get(i);
            if (data.hasNext() && data.currentTime() == minTime) {
                this.putValueToField(data, field);
                data.next();
                if (!data.hasNext()) {
                    FileSeriesReader reader = this.readers.get(i);
                    if (reader.hasNextBatch()) {
                        data = reader.nextBatch();
                        if (data.hasNext()) {
                            this.batchDataList.set(i, data);
                            this.timeHeapPut(data.currentTime());
                        } else {
                            this.hasDataRemaining.set(i, false);
                        }
                    } else {
                        this.hasDataRemaining.set(i, false);
                    }
                } else {
                    this.timeHeapPut(data.currentTime());
                }
                record.addField(field);
                continue;
            }
            record.addField(new Field(null));
        }
        return record;
    }

    private void timeHeapPut(long time) {
        if (!this.timeSet.contains(time)) {
            this.timeSet.add(time);
            this.timeHeap.add(time);
        }
    }

    private Long timeHeapGet() {
        Long t = this.timeHeap.poll();
        this.timeSet.remove(t);
        return t;
    }

    private void putValueToField(BatchData col, Field field) {
        switch (col.getDataType()) {
            case BOOLEAN: {
                field.setBoolV(col.getBoolean());
                break;
            }
            case INT32: {
                field.setIntV(col.getInt());
                break;
            }
            case INT64: {
                field.setLongV(col.getLong());
                break;
            }
            case FLOAT: {
                field.setFloatV(col.getFloat());
                break;
            }
            case DOUBLE: {
                field.setDoubleV(col.getDouble());
                break;
            }
            case TEXT: {
                field.setBinaryV(col.getBinary());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("UnSupported" + String.valueOf((Object)col.getDataType()));
            }
        }
    }
}

