/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import org.apache.iotdb.tsfile.read.filter.DigestForFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.UnaryFilter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;

public class NotEq<T extends Comparable<T>>
extends UnaryFilter<T> {
    private static final long serialVersionUID = 2574090797476500965L;

    public NotEq(T value, FilterType filterType) {
        super(value, filterType);
    }

    @Override
    public boolean satisfy(DigestForFilter digest) {
        if (this.filterType == FilterType.TIME_FILTER) {
            return ((Long)this.value).longValue() != digest.getMinTime() || ((Long)this.value).longValue() != digest.getMaxTime();
        }
        if (digest.isMinValueNull() || digest.isMaxValueNull()) {
            return true;
        }
        return this.value.compareTo(digest.getMinValue()) != 0 || this.value.compareTo(digest.getMaxValue()) != 0;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        Object v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : value;
        return !this.value.equals(v);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            long time = (Long)this.value;
            return time != startTime || time != endTime;
        }
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            long time = (Long)this.value;
            return time < startTime || time > endTime;
        }
        return true;
    }

    @Override
    public Filter clone() {
        return new NotEq<Comparable>(this.value, this.filterType);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getFilterType()) + " != " + this.value;
    }
}

