/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter;

import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.filter.UnSupportFilterDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class DigestForFilter {
    private ByteBuffer minValue;
    private ByteBuffer maxValue;
    private long minTime;
    private long maxTime;
    private TSDataType type;

    public DigestForFilter(long minTime, long maxTime, ByteBuffer minValue, ByteBuffer maxValue, TSDataType type) {
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.type = type;
    }

    public DigestForFilter(long minTime, long maxTime, byte[] minValue, byte[] maxValue, TSDataType type) {
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.minValue = ByteBuffer.wrap(minValue);
        this.maxValue = ByteBuffer.wrap(maxValue);
        this.type = type;
    }

    private <T extends Comparable<T>> T getValue(ByteBuffer value) {
        switch (this.type) {
            case INT32: {
                return (T)Integer.valueOf(BytesUtils.bytesToInt(value.array()));
            }
            case INT64: {
                return (T)Long.valueOf(BytesUtils.bytesToLong(value.array()));
            }
            case FLOAT: {
                return (T)Float.valueOf(BytesUtils.bytesToFloat(value.array()));
            }
            case DOUBLE: {
                return (T)Double.valueOf(BytesUtils.bytesToDouble(value.array()));
            }
            case TEXT: {
                return (T)new Binary(BytesUtils.bytesToString(value.array()));
            }
            case BOOLEAN: {
                return (T)Boolean.valueOf(BytesUtils.bytesToBool(value.array()));
            }
        }
        throw new UnSupportFilterDataTypeException("DigestForFilter unsupported datatype : " + this.type.toString());
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public boolean isMinValueNull() {
        return this.minValue == null;
    }

    public boolean isMaxValueNull() {
        return this.maxValue == null;
    }

    public <T extends Comparable<T>> T getMinValue() {
        return this.getValue(this.minValue);
    }

    public <T extends Comparable<T>> T getMaxValue() {
        return this.getValue(this.maxValue);
    }

    public Class<?> getTypeClass() {
        switch (this.type) {
            case INT32: {
                return Integer.class;
            }
            case INT64: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case TEXT: {
                return String.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
        }
        throw new UnSupportFilterDataTypeException("DigestForFilter unsupported datatype : " + this.type.toString());
    }

    public TSDataType getType() {
        return this.type;
    }
}

