/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.common.cache.LRUCache;
import org.apache.iotdb.tsfile.exception.write.NoMeasurementException;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.controller.IMetadataQuerier;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MetadataQuerierByFileImpl
implements IMetadataQuerier {
    private static final int CHUNK_METADATA_CACHE_SIZE = 10000;
    private TsFileMetaData fileMetaData;
    private LRUCache<Path, List<ChunkMetaData>> chunkMetaDataCache;
    private TsFileSequenceReader tsFileReader;

    public MetadataQuerierByFileImpl(TsFileSequenceReader tsFileReader) throws IOException {
        this.tsFileReader = tsFileReader;
        this.fileMetaData = tsFileReader.readFileMetadata();
        this.chunkMetaDataCache = new LRUCache<Path, List<ChunkMetaData>>(10000){

            @Override
            public List<ChunkMetaData> loadObjectByKey(Path key) throws IOException {
                return MetadataQuerierByFileImpl.this.loadChunkMetadata(key);
            }
        };
    }

    @Override
    public List<ChunkMetaData> getChunkMetaDataList(Path path) throws IOException {
        return this.chunkMetaDataCache.get(path);
    }

    @Override
    public Map<Path, List<ChunkMetaData>> getChunkMetaDataMap(List<Path> paths) throws IOException {
        HashMap<Path, List<ChunkMetaData>> chunkMetaDatas = new HashMap<Path, List<ChunkMetaData>>();
        for (Path path : paths) {
            if (!chunkMetaDatas.containsKey(path)) {
                chunkMetaDatas.put(path, new ArrayList());
            }
            ((List)chunkMetaDatas.get(path)).addAll(this.getChunkMetaDataList(path));
        }
        return chunkMetaDatas;
    }

    @Override
    public TsFileMetaData getWholeFileMetadata() {
        return this.fileMetaData;
    }

    @Override
    public void loadChunkMetaDatas(List<Path> paths) throws IOException {
        TreeMap deviceMeasurementsMap = new TreeMap();
        for (Path path : paths) {
            if (!deviceMeasurementsMap.containsKey(path.getDevice())) {
                deviceMeasurementsMap.put(path.getDevice(), new HashSet());
            }
            ((Set)deviceMeasurementsMap.get(path.getDevice())).add(path.getMeasurement());
        }
        HashMap tempChunkMetaDatas = new HashMap();
        int count = 0;
        boolean enough = false;
        block1: for (Map.Entry deviceMeasurements : deviceMeasurementsMap.entrySet()) {
            if (enough) break;
            String selectedDevice = (String)deviceMeasurements.getKey();
            Set selectedMeasurements = (Set)deviceMeasurements.getValue();
            TsDeviceMetadataIndex index = this.fileMetaData.getDeviceMetadataIndex(selectedDevice);
            TsDeviceMetadata tsDeviceMetadata = this.tsFileReader.readTsDeviceMetaData(index);
            if (tsDeviceMetadata == null) continue;
            block2: for (ChunkGroupMetaData chunkGroupMetaData : tsDeviceMetadata.getChunkGroupMetaDataList()) {
                if (enough) continue block1;
                for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                    String currentMeasurement = chunkMetaData.getMeasurementUid();
                    if (!selectedMeasurements.contains(currentMeasurement)) continue;
                    Path path = new Path(selectedDevice, currentMeasurement);
                    if (!tempChunkMetaDatas.containsKey(path)) {
                        tempChunkMetaDatas.put(path, new ArrayList());
                    }
                    ((List)tempChunkMetaDatas.get(path)).add(chunkMetaData);
                    if (++count != 10000) continue;
                    enough = true;
                    continue block2;
                }
            }
        }
        for (Map.Entry entry : tempChunkMetaDatas.entrySet()) {
            this.chunkMetaDataCache.put((Path)entry.getKey(), (List<ChunkMetaData>)entry.getValue());
        }
    }

    @Override
    public TSDataType getDataType(String measurement) throws NoMeasurementException {
        MeasurementSchema measurementSchema = this.fileMetaData.getMeasurementSchema().get(measurement);
        if (measurementSchema != null) {
            return measurementSchema.getType();
        }
        throw new NoMeasurementException(String.format("%s not found.", measurement));
    }

    private List<ChunkMetaData> loadChunkMetadata(Path path) throws IOException {
        return this.tsFileReader.getChunkMetadataList(path);
    }

    @Override
    public List<TimeRange> convertSpace2TimePartition(List<Path> paths, long spacePartitionStartPos, long spacePartitionEndPos) throws IOException {
        if (spacePartitionStartPos > spacePartitionEndPos) {
            throw new IllegalArgumentException("'spacePartitionStartPos' should not be larger than 'spacePartitionEndPos'.");
        }
        ArrayList<TimeRange> timeRangesInCandidates = new ArrayList<TimeRange>();
        ArrayList<TimeRange> timeRangesBeforeCandidates = new ArrayList<TimeRange>();
        TreeMap deviceMeasurementsMap = new TreeMap();
        for (Path path : paths) {
            if (!deviceMeasurementsMap.containsKey(path.getDevice())) {
                deviceMeasurementsMap.put(path.getDevice(), new HashSet());
            }
            ((Set)deviceMeasurementsMap.get(path.getDevice())).add(path.getMeasurement());
        }
        for (Map.Entry entry : deviceMeasurementsMap.entrySet()) {
            String selectedDevice = (String)entry.getKey();
            Set selectedMeasurements = (Set)entry.getValue();
            TsDeviceMetadataIndex index = this.fileMetaData.getDeviceMetadataIndex(selectedDevice);
            TsDeviceMetadata tsDeviceMetadata = this.tsFileReader.readTsDeviceMetaData(index);
            for (ChunkGroupMetaData chunkGroupMetaData : tsDeviceMetadata.getChunkGroupMetaDataList()) {
                LocateStatus mode = this.checkLocateStatus(chunkGroupMetaData, spacePartitionStartPos, spacePartitionEndPos);
                if (mode == LocateStatus.after) continue;
                for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                    String currentMeasurement = chunkMetaData.getMeasurementUid();
                    if (!selectedMeasurements.contains(currentMeasurement)) continue;
                    TimeRange timeRange = new TimeRange(chunkMetaData.getStartTime(), chunkMetaData.getEndTime());
                    if (mode == LocateStatus.in) {
                        timeRangesInCandidates.add(timeRange);
                        continue;
                    }
                    timeRangesBeforeCandidates.add(timeRange);
                }
            }
        }
        ArrayList<TimeRange> timeRangesIn = new ArrayList<TimeRange>(TimeRange.sortAndMerge(timeRangesInCandidates));
        if (timeRangesIn.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TimeRange> arrayList = new ArrayList<TimeRange>(TimeRange.sortAndMerge(timeRangesBeforeCandidates));
        ArrayList<TimeRange> resTimeRanges = new ArrayList<TimeRange>();
        for (TimeRange in : timeRangesIn) {
            ArrayList<TimeRange> remains = new ArrayList<TimeRange>(in.getRemains(arrayList));
            resTimeRanges.addAll(remains);
        }
        return resTimeRanges;
    }

    private LocateStatus checkLocateStatus(ChunkGroupMetaData chunkGroupMetaData, long spacePartitionStartPos, long spacePartitionEndPos) {
        long endOffsetOfChunkGroup;
        long startOffsetOfChunkGroup = chunkGroupMetaData.getStartOffsetOfChunkGroup();
        long middleOffsetOfChunkGroup = (startOffsetOfChunkGroup + (endOffsetOfChunkGroup = chunkGroupMetaData.getEndOffsetOfChunkGroup())) / 2L;
        if (spacePartitionStartPos <= middleOffsetOfChunkGroup && middleOffsetOfChunkGroup < spacePartitionEndPos) {
            return LocateStatus.in;
        }
        if (middleOffsetOfChunkGroup < spacePartitionStartPos) {
            return LocateStatus.before;
        }
        return LocateStatus.after;
    }

    @Override
    public void clear() {
        this.chunkMetaDataCache.clear();
    }

    private static enum LocateStatus {
        in,
        before,
        after;

    }
}

