/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class BatchData
implements Serializable {
    private static final long serialVersionUID = -4620310601188394839L;
    private int timeCapacity = 16;
    private int valueCapacity = 16;
    private int emptyTimeCapacity = 1;
    private int capacityThreshold = 1024;
    private TSDataType dataType;
    private int curIdx;
    private int timeArrayIdx;
    private int curTimeIdx;
    private int timeLength;
    private int valueArrayIdx;
    private int curValueIdx;
    private int valueLength;
    private ArrayList<long[]> timeRet;
    private ArrayList<long[]> emptyTimeRet;
    private ArrayList<boolean[]> booleanRet;
    private ArrayList<int[]> intRet;
    private ArrayList<long[]> longRet;
    private ArrayList<float[]> floatRet;
    private ArrayList<double[]> doubleRet;
    private ArrayList<Binary[]> binaryRet;

    public BatchData() {
        this.dataType = null;
    }

    public BatchData(TSDataType type) {
        this.dataType = type;
    }

    public BatchData(TSDataType type, boolean recordTime) {
        this.init(type, recordTime, false);
    }

    public BatchData(TSDataType type, boolean recordTime, boolean hasEmptyTime) {
        this.init(type, recordTime, hasEmptyTime);
    }

    public boolean hasNext() {
        return this.curIdx < this.timeLength;
    }

    public void next() {
        ++this.curIdx;
    }

    public long currentTime() {
        this.rangeCheckForTime(this.curIdx);
        return this.timeRet.get(this.curIdx / this.timeCapacity)[this.curIdx % this.timeCapacity];
    }

    public Object currentValue() {
        switch (this.dataType) {
            case INT32: {
                return this.getInt();
            }
            case INT64: {
                return this.getLong();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat());
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case BOOLEAN: {
                return this.getBoolean();
            }
            case TEXT: {
                return this.getBinary();
            }
        }
        return null;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void init(TSDataType type, boolean recordTime, boolean hasEmptyTime) {
        this.dataType = type;
        this.valueArrayIdx = 0;
        this.curValueIdx = 0;
        this.valueLength = 0;
        this.curIdx = 0;
        this.capacityThreshold = 1000;
        if (recordTime) {
            this.timeRet = new ArrayList();
            this.timeRet.add(new long[this.timeCapacity]);
            this.timeArrayIdx = 0;
            this.curTimeIdx = 0;
            this.timeLength = 0;
        }
        if (hasEmptyTime) {
            this.emptyTimeRet = new ArrayList();
            this.emptyTimeRet.add(new long[this.emptyTimeCapacity]);
        }
        switch (this.dataType) {
            case BOOLEAN: {
                this.booleanRet = new ArrayList();
                this.booleanRet.add(new boolean[this.valueCapacity]);
                break;
            }
            case INT32: {
                this.intRet = new ArrayList();
                this.intRet.add(new int[this.valueCapacity]);
                break;
            }
            case INT64: {
                this.longRet = new ArrayList();
                this.longRet.add(new long[this.valueCapacity]);
                break;
            }
            case FLOAT: {
                this.floatRet = new ArrayList();
                this.floatRet.add(new float[this.valueCapacity]);
                break;
            }
            case DOUBLE: {
                this.doubleRet = new ArrayList();
                this.doubleRet.add(new double[this.valueCapacity]);
                break;
            }
            case TEXT: {
                this.binaryRet = new ArrayList();
                this.binaryRet.add(new Binary[this.valueCapacity]);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
            }
        }
    }

    public void putTime(long v) {
        if (this.curTimeIdx == this.timeCapacity) {
            if (this.timeCapacity >= this.capacityThreshold) {
                this.timeRet.add(new long[this.timeCapacity]);
                ++this.timeArrayIdx;
                this.curTimeIdx = 0;
            } else {
                long[] newData = new long[this.timeCapacity * 2];
                System.arraycopy(this.timeRet.get(0), 0, newData, 0, this.timeCapacity);
                this.timeRet.set(0, newData);
                this.timeCapacity *= 2;
            }
        }
        this.timeRet.get((int)this.timeArrayIdx)[this.curTimeIdx++] = v;
        ++this.timeLength;
    }

    public void putBoolean(boolean v) {
        if (this.curValueIdx == this.valueCapacity) {
            if (this.valueCapacity >= this.capacityThreshold) {
                if (this.booleanRet.size() <= this.valueArrayIdx + 1) {
                    this.booleanRet.add(new boolean[this.valueCapacity]);
                }
                ++this.valueArrayIdx;
                this.curValueIdx = 0;
            } else {
                boolean[] newData = new boolean[this.valueCapacity * 2];
                System.arraycopy(this.booleanRet.get(0), 0, newData, 0, this.valueCapacity);
                this.booleanRet.set(0, newData);
                this.valueCapacity *= 2;
            }
        }
        this.booleanRet.get((int)this.valueArrayIdx)[this.curValueIdx++] = v;
        ++this.valueLength;
    }

    public void putInt(int v) {
        if (this.curValueIdx == this.valueCapacity) {
            if (this.valueCapacity >= this.capacityThreshold) {
                if (this.intRet.size() <= this.valueArrayIdx + 1) {
                    this.intRet.add(new int[this.valueCapacity]);
                }
                ++this.valueArrayIdx;
                this.curValueIdx = 0;
            } else {
                int[] newData = new int[this.valueCapacity * 2];
                System.arraycopy(this.intRet.get(0), 0, newData, 0, this.valueCapacity);
                this.intRet.set(0, newData);
                this.valueCapacity *= 2;
            }
        }
        this.intRet.get((int)this.valueArrayIdx)[this.curValueIdx++] = v;
        ++this.valueLength;
    }

    public void putLong(long v) {
        if (this.curValueIdx == this.valueCapacity) {
            if (this.valueCapacity >= this.capacityThreshold) {
                if (this.longRet.size() <= this.valueArrayIdx + 1) {
                    this.longRet.add(new long[this.valueCapacity]);
                }
                ++this.valueArrayIdx;
                this.curValueIdx = 0;
            } else {
                long[] newData = new long[this.valueCapacity * 2];
                System.arraycopy(this.longRet.get(0), 0, newData, 0, this.valueCapacity);
                this.longRet.set(0, newData);
                this.valueCapacity *= 2;
            }
        }
        this.longRet.get((int)this.valueArrayIdx)[this.curValueIdx++] = v;
        ++this.valueLength;
    }

    public void putFloat(float v) {
        if (this.curValueIdx == this.valueCapacity) {
            if (this.valueCapacity >= this.capacityThreshold) {
                if (this.floatRet.size() <= this.valueArrayIdx + 1) {
                    this.floatRet.add(new float[this.valueCapacity]);
                }
                ++this.valueArrayIdx;
                this.curValueIdx = 0;
            } else {
                float[] newData = new float[this.valueCapacity * 2];
                System.arraycopy(this.floatRet.get(0), 0, newData, 0, this.valueCapacity);
                this.floatRet.set(0, newData);
                this.valueCapacity *= 2;
            }
        }
        this.floatRet.get((int)this.valueArrayIdx)[this.curValueIdx++] = v;
        ++this.valueLength;
    }

    public void putDouble(double v) {
        if (this.curValueIdx == this.valueCapacity) {
            if (this.valueCapacity >= this.capacityThreshold) {
                if (this.doubleRet.size() <= this.valueArrayIdx + 1) {
                    this.doubleRet.add(new double[this.valueCapacity]);
                }
                ++this.valueArrayIdx;
                this.curValueIdx = 0;
            } else {
                double[] newData = new double[this.valueCapacity * 2];
                System.arraycopy(this.doubleRet.get(0), 0, newData, 0, this.valueCapacity);
                this.doubleRet.set(0, newData);
                this.valueCapacity *= 2;
            }
        }
        this.doubleRet.get((int)this.valueArrayIdx)[this.curValueIdx++] = v;
        ++this.valueLength;
    }

    public void putBinary(Binary v) {
        if (this.curValueIdx == this.valueCapacity) {
            if (this.valueCapacity >= this.capacityThreshold) {
                if (this.binaryRet.size() <= this.valueArrayIdx + 1) {
                    this.binaryRet.add(new Binary[this.valueCapacity]);
                }
                ++this.valueArrayIdx;
                this.curValueIdx = 0;
            } else {
                Binary[] newData = new Binary[this.valueCapacity * 2];
                System.arraycopy(this.binaryRet.get(0), 0, newData, 0, this.valueCapacity);
                this.binaryRet.set(0, newData);
                this.valueCapacity *= 2;
            }
        }
        this.binaryRet.get((int)this.valueArrayIdx)[this.curValueIdx++] = v;
        ++this.valueLength;
    }

    private void rangeCheck(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("BatchData value range check, Index is negative: " + idx);
        }
        if (idx >= this.valueLength) {
            throw new IndexOutOfBoundsException("BatchData value range check, Index : " + idx + ". Length : " + this.valueLength);
        }
    }

    private void rangeCheckForTime(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("BatchData time range check, Index is negative: " + idx);
        }
        if (idx >= this.timeLength) {
            throw new IndexOutOfBoundsException("BatchData time range check, Index : " + idx + ". Length : " + this.timeLength);
        }
    }

    private void rangeCheckForEmptyTime(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("BatchData empty time range check, Index is negative: " + idx);
        }
    }

    public boolean getBoolean() {
        this.rangeCheck(this.curIdx);
        return this.booleanRet.get(this.curIdx / this.timeCapacity)[this.curIdx % this.timeCapacity];
    }

    public void setBoolean(int idx, boolean v) {
        this.rangeCheck(idx);
        this.booleanRet.get((int)(idx / this.timeCapacity))[idx % this.timeCapacity] = v;
    }

    public int getInt() {
        this.rangeCheck(this.curIdx);
        return this.intRet.get(this.curIdx / this.timeCapacity)[this.curIdx % this.timeCapacity];
    }

    public void setInt(int idx, int v) {
        this.rangeCheck(idx);
        this.intRet.get((int)(idx / this.timeCapacity))[idx % this.timeCapacity] = v;
    }

    public long getLong() {
        this.rangeCheck(this.curIdx);
        return this.longRet.get(this.curIdx / this.timeCapacity)[this.curIdx % this.timeCapacity];
    }

    public void setLong(int idx, long v) {
        this.rangeCheck(idx);
        this.longRet.get((int)(idx / this.timeCapacity))[idx % this.timeCapacity] = v;
    }

    public float getFloat() {
        this.rangeCheck(this.curIdx);
        return this.floatRet.get(this.curIdx / this.timeCapacity)[this.curIdx % this.timeCapacity];
    }

    public void setFloat(int idx, float v) {
        this.rangeCheck(idx);
        this.floatRet.get((int)(idx / this.timeCapacity))[idx % this.timeCapacity] = v;
    }

    public double getDouble() {
        this.rangeCheck(this.curIdx);
        return this.doubleRet.get(this.curIdx / this.timeCapacity)[this.curIdx % this.timeCapacity];
    }

    public void setDouble(int idx, double v) {
        this.rangeCheck(idx);
        this.doubleRet.get((int)(idx / this.timeCapacity))[idx % this.timeCapacity] = v;
    }

    public Binary getBinary() {
        this.rangeCheck(this.curIdx);
        return this.binaryRet.get(this.curIdx / this.timeCapacity)[this.curIdx % this.timeCapacity];
    }

    public void setBinary(int idx, Binary v) {
        this.binaryRet.get((int)(idx / this.timeCapacity))[idx % this.timeCapacity] = v;
    }

    public void setTime(int idx, long v) {
        this.rangeCheckForTime(idx);
        this.timeRet.get((int)(idx / this.timeCapacity))[idx % this.timeCapacity] = v;
    }

    public long getEmptyTime(int idx) {
        this.rangeCheckForEmptyTime(idx);
        return this.emptyTimeRet.get(idx / this.emptyTimeCapacity)[idx % this.emptyTimeCapacity];
    }

    public long[] getTimeAsArray() {
        long[] res = new long[this.timeLength];
        for (int i = 0; i < this.timeLength; ++i) {
            res[i] = this.timeRet.get(i / this.timeCapacity)[i % this.timeCapacity];
        }
        return res;
    }

    public void putAnObject(Object v) {
        switch (this.dataType) {
            case BOOLEAN: {
                this.putBoolean((Boolean)v);
                break;
            }
            case INT32: {
                this.putInt((Integer)v);
                break;
            }
            case INT64: {
                this.putLong((Long)v);
                break;
            }
            case FLOAT: {
                this.putFloat(((Float)v).floatValue());
                break;
            }
            case DOUBLE: {
                this.putDouble((Double)v);
                break;
            }
            case TEXT: {
                this.putBinary((Binary)v);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
            }
        }
    }

    public void setAnObject(int idx, Comparable<?> v) {
        switch (this.dataType) {
            case BOOLEAN: {
                this.setBoolean(idx, (Boolean)v);
                break;
            }
            case DOUBLE: {
                this.setDouble(idx, (Double)v);
                break;
            }
            case TEXT: {
                this.setBinary(idx, (Binary)v);
                break;
            }
            case FLOAT: {
                this.setFloat(idx, ((Float)v).floatValue());
                break;
            }
            case INT32: {
                this.setInt(idx, (Integer)v);
                break;
            }
            case INT64: {
                this.setLong(idx, (Long)v);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
            }
        }
    }

    public int length() {
        return this.timeLength;
    }

    public int getCurIdx() {
        return this.curIdx;
    }

    public long getTimeByIndex(int idx) {
        this.rangeCheckForTime(idx);
        return this.timeRet.get(idx / this.timeCapacity)[idx % this.timeCapacity];
    }

    public long getLongByIndex(int idx) {
        this.rangeCheck(idx);
        return this.longRet.get(idx / this.timeCapacity)[idx % this.timeCapacity];
    }

    public double getDoubleByIndex(int idx) {
        this.rangeCheck(idx);
        return this.doubleRet.get(idx / this.timeCapacity)[idx % this.timeCapacity];
    }

    public int getIntByIndex(int idx) {
        this.rangeCheck(idx);
        return this.intRet.get(idx / this.timeCapacity)[idx % this.timeCapacity];
    }

    public float getFloatByIndex(int idx) {
        this.rangeCheck(idx);
        return this.floatRet.get(idx / this.timeCapacity)[idx % this.timeCapacity];
    }

    public Binary getBinaryByIndex(int idx) {
        this.rangeCheck(idx);
        return this.binaryRet.get(idx / this.timeCapacity)[idx % this.timeCapacity];
    }

    public boolean getBooleanByIndex(int idx) {
        this.rangeCheck(idx);
        return this.booleanRet.get(idx / this.timeCapacity)[idx % this.timeCapacity];
    }

    public Object getValueByIndex(int idx) {
        switch (this.dataType) {
            case INT32: {
                return this.getIntByIndex(idx);
            }
            case INT64: {
                return this.getLongByIndex(idx);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloatByIndex(idx));
            }
            case DOUBLE: {
                return this.getDoubleByIndex(idx);
            }
            case BOOLEAN: {
                return this.getBooleanByIndex(idx);
            }
            case TEXT: {
                return this.getBinaryByIndex(idx);
            }
        }
        return null;
    }

    public Object getValueInTimestamp(long time) {
        while (this.hasNext()) {
            if (this.currentTime() < time) {
                this.next();
                continue;
            }
            if (this.currentTime() == time) {
                Object value = this.currentValue();
                this.next();
                return value;
            }
            return null;
        }
        return null;
    }
}

