/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.IOException;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IMetadataQuerier;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.executor.TsFileExecutor;

public class ReadOnlyTsFile
implements AutoCloseable {
    private TsFileSequenceReader fileReader;
    private IMetadataQuerier metadataQuerier;
    private IChunkLoader chunkLoader;
    private TsFileExecutor tsFileExecutor;

    public ReadOnlyTsFile(TsFileSequenceReader fileReader) throws IOException {
        this.fileReader = fileReader;
        this.metadataQuerier = new MetadataQuerierByFileImpl(fileReader);
        this.chunkLoader = new ChunkLoaderImpl(fileReader);
        this.tsFileExecutor = new TsFileExecutor(this.metadataQuerier, this.chunkLoader);
    }

    public QueryDataSet query(QueryExpression queryExpression) throws IOException {
        return this.tsFileExecutor.execute(queryExpression);
    }

    public QueryDataSet query(QueryExpression queryExpression, long partitionStartOffset, long partitionEndOffset) throws IOException {
        return this.tsFileExecutor.execute(queryExpression, partitionStartOffset, partitionEndOffset);
    }

    @Override
    public void close() throws IOException {
        this.fileReader.close();
    }
}

