/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.fileSystem.fileInputFactory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.tsfile.fileSystem.fileInputFactory.FileInputFactory;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSInputFactory
implements FileInputFactory {
    private static final Logger logger = LoggerFactory.getLogger(HDFSInputFactory.class);
    private static Constructor constructor;

    @Override
    public TsFileInput getTsFileInput(String filePath) {
        try {
            return (TsFileInput)constructor.newInstance(filePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error("Failed to get TsFile input of file: {}. Please check your dependency of Hadoop module.", (Object)filePath, (Object)e);
            return null;
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.apache.iotdb.hadoop.fileSystem.HDFSInput");
            constructor = clazz.getConstructor(String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            logger.error("Failed to get HDFSInput in Hadoop file system. Please check your dependency of Hadoop module.", (Throwable)e);
        }
    }
}

