/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class TsFileMetaData {
    private Map<String, TsDeviceMetadataIndex> deviceIndexMap = new HashMap<String, TsDeviceMetadataIndex>();
    private Map<String, MeasurementSchema> measurementSchema = new HashMap<String, MeasurementSchema>();
    private String createdBy;
    private int totalChunkNum;
    private int invalidChunkNum;
    private BloomFilter bloomFilter;

    public TsFileMetaData() {
    }

    public TsFileMetaData(Map<String, TsDeviceMetadataIndex> deviceMap, Map<String, MeasurementSchema> measurementSchema) {
        this.deviceIndexMap = deviceMap;
        this.measurementSchema = measurementSchema;
    }

    public static TsFileMetaData deserializeFrom(InputStream inputStream, boolean isOldVersion) throws IOException {
        TsFileMetaData fileMetaData = new TsFileMetaData();
        int size = ReadWriteIOUtils.readInt(inputStream);
        if (size > 0) {
            HashMap<String, TsDeviceMetadataIndex> deviceMap = new HashMap<String, TsDeviceMetadataIndex>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(inputStream);
                TsDeviceMetadataIndex value = TsDeviceMetadataIndex.deserializeFrom(inputStream);
                deviceMap.put(key, value);
            }
            fileMetaData.deviceIndexMap = deviceMap;
        }
        if ((size = ReadWriteIOUtils.readInt(inputStream)) > 0) {
            fileMetaData.measurementSchema = new HashMap<String, MeasurementSchema>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(inputStream);
                MeasurementSchema value = MeasurementSchema.deserializeFrom(inputStream);
                fileMetaData.measurementSchema.put(key, value);
            }
        }
        if (isOldVersion) {
            ReadWriteIOUtils.readInt(inputStream);
        }
        if (ReadWriteIOUtils.readIsNull(inputStream)) {
            fileMetaData.createdBy = ReadWriteIOUtils.readString(inputStream);
        }
        if (isOldVersion) {
            fileMetaData.totalChunkNum = 0;
            fileMetaData.invalidChunkNum = 0;
        } else {
            fileMetaData.totalChunkNum = ReadWriteIOUtils.readInt(inputStream);
            fileMetaData.invalidChunkNum = ReadWriteIOUtils.readInt(inputStream);
        }
        if (!ReadWriteIOUtils.checkIfMagicString(inputStream)) {
            byte[] bytes = ReadWriteIOUtils.readBytesWithSelfDescriptionLength(inputStream);
            int filterSize = ReadWriteIOUtils.readInt(inputStream);
            int hashFunctionSize = ReadWriteIOUtils.readInt(inputStream);
            fileMetaData.bloomFilter = BloomFilter.buildBloomFilter(bytes, filterSize, hashFunctionSize);
        }
        return fileMetaData;
    }

    public static TsFileMetaData deserializeFrom(ByteBuffer buffer, boolean isOldVersion) throws IOException {
        TsFileMetaData fileMetaData = new TsFileMetaData();
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            HashMap<String, TsDeviceMetadataIndex> deviceMap = new HashMap<String, TsDeviceMetadataIndex>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                TsDeviceMetadataIndex value = TsDeviceMetadataIndex.deserializeFrom(buffer);
                deviceMap.put(key, value);
            }
            fileMetaData.deviceIndexMap = deviceMap;
        }
        if ((size = ReadWriteIOUtils.readInt(buffer)) > 0) {
            fileMetaData.measurementSchema = new HashMap<String, MeasurementSchema>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                MeasurementSchema value = MeasurementSchema.deserializeFrom(buffer);
                fileMetaData.measurementSchema.put(key, value);
            }
        }
        if (isOldVersion) {
            ReadWriteIOUtils.readInt(buffer);
        }
        if (ReadWriteIOUtils.readIsNull(buffer)) {
            fileMetaData.createdBy = ReadWriteIOUtils.readString(buffer);
        }
        if (isOldVersion) {
            fileMetaData.totalChunkNum = 0;
            fileMetaData.invalidChunkNum = 0;
        } else {
            fileMetaData.totalChunkNum = ReadWriteIOUtils.readInt(buffer);
            fileMetaData.invalidChunkNum = ReadWriteIOUtils.readInt(buffer);
        }
        if (buffer.hasRemaining()) {
            byte[] bytes = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer).array();
            int filterSize = ReadWriteIOUtils.readInt(buffer);
            int hashFunctionSize = ReadWriteIOUtils.readInt(buffer);
            fileMetaData.bloomFilter = BloomFilter.buildBloomFilter(bytes, filterSize, hashFunctionSize);
        }
        return fileMetaData;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public void addMeasurementSchema(MeasurementSchema measurementSchema) {
        this.measurementSchema.put(measurementSchema.getMeasurementId(), measurementSchema);
    }

    public String toString() {
        return "TsFileMetaData{deviceIndexMap=" + this.deviceIndexMap + ", measurementSchema=" + this.measurementSchema + ", createdBy='" + this.createdBy + '\'' + '}';
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Map<String, TsDeviceMetadataIndex> getDeviceMap() {
        return this.deviceIndexMap;
    }

    public void setDeviceMap(Map<String, TsDeviceMetadataIndex> deviceMap) {
        this.deviceIndexMap = deviceMap;
    }

    public boolean containsDevice(String deltaObjUid) {
        return this.deviceIndexMap.containsKey(deltaObjUid);
    }

    public TsDeviceMetadataIndex getDeviceMetadataIndex(String deviceUid) {
        return this.deviceIndexMap.get(deviceUid);
    }

    public boolean containsMeasurement(String measurement) {
        return this.measurementSchema.containsKey(measurement);
    }

    public TSDataType getType(String measurement) {
        if (this.containsMeasurement(measurement)) {
            return this.measurementSchema.get(measurement).getType();
        }
        return null;
    }

    public Map<String, MeasurementSchema> getMeasurementSchema() {
        return this.measurementSchema;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.deviceIndexMap.size(), outputStream);
        for (Map.Entry<String, TsDeviceMetadataIndex> entry : this.deviceIndexMap.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
            byteLen += entry.getValue().serializeTo(outputStream);
        }
        byteLen += ReadWriteIOUtils.write(this.measurementSchema.size(), outputStream);
        for (Map.Entry<String, Object> entry : this.measurementSchema.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
            byteLen += ((MeasurementSchema)entry.getValue()).serializeTo(outputStream);
        }
        byteLen += ReadWriteIOUtils.writeIsNotNull((Object)this.createdBy, outputStream);
        if (this.createdBy != null) {
            byteLen += ReadWriteIOUtils.write(this.createdBy, outputStream);
        }
        byteLen += ReadWriteIOUtils.write(this.totalChunkNum, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.invalidChunkNum, outputStream);
    }

    public int serializeBloomFilter(OutputStream outputStream, List<ChunkGroupMetaData> chunkGroupMetaDataList) throws IOException {
        int byteLen = 0;
        BloomFilter filter = this.buildBloomFilter(chunkGroupMetaDataList);
        byte[] bytes = filter.serialize();
        byteLen += ReadWriteIOUtils.write(bytes.length, outputStream);
        outputStream.write(bytes);
        byteLen += bytes.length;
        byteLen += ReadWriteIOUtils.write(filter.getSize(), outputStream);
        return byteLen += ReadWriteIOUtils.write(filter.getHashFunctionSize(), outputStream);
    }

    private List<String> getAllPath(List<ChunkGroupMetaData> chunkGroupMetaDataList) {
        ArrayList<String> res = new ArrayList<String>();
        for (ChunkGroupMetaData chunkGroupMetaData : chunkGroupMetaDataList) {
            String deviceId = chunkGroupMetaData.getDeviceID();
            for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                res.add(deviceId + "." + chunkMetaData.getMeasurementUid());
            }
        }
        return res;
    }

    private BloomFilter buildBloomFilter(List<ChunkGroupMetaData> chunkGroupMetaDataList) {
        List<String> paths = this.getAllPath(chunkGroupMetaDataList);
        BloomFilter bloomFilter = BloomFilter.getEmptyBloomFilter(TSFileDescriptor.getInstance().getConfig().getBloomFilterErrorRate(), paths.size());
        for (String path : paths) {
            bloomFilter.add(path);
        }
        return bloomFilter;
    }

    public int serializeTo(ByteBuffer buffer) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.deviceIndexMap.size(), buffer);
        for (Map.Entry<String, TsDeviceMetadataIndex> entry : this.deviceIndexMap.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
            byteLen += entry.getValue().serializeTo(buffer);
        }
        byteLen += ReadWriteIOUtils.write(this.measurementSchema.size(), buffer);
        for (Map.Entry<String, Object> entry : this.measurementSchema.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
            byteLen += ((MeasurementSchema)entry.getValue()).serializeTo(buffer);
        }
        byteLen += ReadWriteIOUtils.writeIsNotNull((Object)this.createdBy, buffer);
        if (this.createdBy != null) {
            byteLen += ReadWriteIOUtils.write(this.createdBy, buffer);
        }
        byteLen += ReadWriteIOUtils.write(this.totalChunkNum, buffer);
        return byteLen += ReadWriteIOUtils.write(this.invalidChunkNum, buffer);
    }

    public int getTotalChunkNum() {
        return this.totalChunkNum;
    }

    public void setTotalChunkNum(int totalChunkNum) {
        this.totalChunkNum = totalChunkNum;
    }

    public int getInvalidChunkNum() {
        return this.invalidChunkNum;
    }

    public void setInvalidChunkNum(int invalidChunkNum) {
        this.invalidChunkNum = invalidChunkNum;
    }

    public List<MeasurementSchema> getMeasurementSchemaList() {
        return new ArrayList<MeasurementSchema>(this.measurementSchema.values());
    }

    public void setDeviceIndexMap(Map<String, TsDeviceMetadataIndex> deviceIndexMap) {
        this.deviceIndexMap = deviceIndexMap;
    }

    public void setMeasurementSchema(Map<String, MeasurementSchema> measurementSchema) {
        this.measurementSchema = measurementSchema;
    }
}

