/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.common.EndianType;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.exception.encoding.TsFileDecodingException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class RleDecoder
extends Decoder {
    private EndianType endianType;
    protected TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    protected Mode mode;
    protected int bitWidth;
    protected int currentCount;
    protected int length;
    protected boolean isLengthAndBitWidthReaded;
    protected ByteBuffer byteCache;
    protected int bitPackingNum;

    @Override
    public EndianType getEndianType() {
        return this.endianType;
    }

    @Override
    public void setEndianType(EndianType endianType) {
        this.endianType = endianType;
    }

    public RleDecoder(EndianType endianType) {
        super(TSEncoding.RLE);
        this.endianType = endianType;
        this.reset();
    }

    @Override
    public void reset() {
        this.currentCount = 0;
        this.isLengthAndBitWidthReaded = false;
        this.bitPackingNum = 0;
        this.byteCache = ByteBuffer.allocate(0);
    }

    public int getHeader() throws IOException {
        int header = ReadWriteForEncodingUtils.readUnsignedVarInt(this.byteCache);
        this.mode = (header & 1) == 0 ? Mode.RLE : Mode.BIT_PACKED;
        return header;
    }

    protected void readNext() throws IOException {
        int header = this.getHeader();
        switch (this.mode) {
            case RLE: {
                this.currentCount = header >> 1;
                this.readNumberInRle();
                break;
            }
            case BIT_PACKED: {
                this.callReadBitPackingBuffer(header);
                break;
            }
            default: {
                throw new TsFileDecodingException(String.format("tsfile-encoding IntRleDecoder: unknown encoding mode %s", new Object[]{this.mode}));
            }
        }
    }

    protected void callReadBitPackingBuffer(int header) throws IOException {
        int bitPackedGroupCount = header >> 1;
        int lastBitPackedNum = ReadWriteIOUtils.read(this.byteCache);
        if (bitPackedGroupCount <= 0) {
            throw new TsFileDecodingException(String.format("tsfile-encoding IntRleDecoder: bitPackedGroupCount %d, smaller than 1", bitPackedGroupCount));
        }
        this.bitPackingNum = this.currentCount = (bitPackedGroupCount - 1) * 8 + lastBitPackedNum;
        this.readBitPackingBuffer(bitPackedGroupCount, lastBitPackedNum);
    }

    protected void readLengthAndBitWidth(ByteBuffer buffer) {
        this.length = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        byte[] tmp = new byte[this.length];
        buffer.get(tmp, 0, this.length);
        this.byteCache = ByteBuffer.wrap(tmp);
        this.isLengthAndBitWidthReaded = true;
        this.bitWidth = ReadWriteIOUtils.read(this.byteCache);
        this.initPacker();
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        return this.currentCount > 0 || buffer.remaining() > 0 || this.hasNextPackage();
    }

    protected boolean hasNextPackage() {
        return this.currentCount > 0 || this.byteCache.remaining() > 0;
    }

    protected abstract void initPacker();

    protected abstract void readNumberInRle() throws IOException;

    protected abstract void readBitPackingBuffer(int var1, int var2) throws IOException;

    @Override
    public boolean readBoolean(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBoolean is not supproted by RleDecoder");
    }

    @Override
    public short readShort(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readShort is not supproted by RleDecoder");
    }

    @Override
    public int readInt(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readInt is not supproted by RleDecoder");
    }

    @Override
    public long readLong(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readLong is not supproted by RleDecoder");
    }

    @Override
    public float readFloat(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readFloat is not supproted by RleDecoder");
    }

    @Override
    public double readDouble(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readDouble is not supproted by RleDecoder");
    }

    @Override
    public Binary readBinary(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBinary is not supproted by RleDecoder");
    }

    @Override
    public BigDecimal readBigDecimal(ByteBuffer buffer) {
        throw new TsFileDecodingException("Method readBigDecimal is not supproted by RleDecoder");
    }

    protected static enum Mode {
        RLE,
        BIT_PACKED;

    }
}

