/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.manager;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.writelog.manager.WriteLogNodeManager;
import org.apache.iotdb.db.writelog.node.ExclusiveWriteLogNode;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFileLogNodeManager
implements WriteLogNodeManager,
IService {
    private static final Logger logger = LoggerFactory.getLogger(MultiFileLogNodeManager.class);
    private Map<String, WriteLogNode> nodeMap;
    private Thread forceThread;
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Runnable forceTask = () -> {
        while (true) {
            if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
                logger.warn("system mode is read-only, the force flush WAL task is stopped");
                return;
            }
            if (Thread.interrupted()) {
                logger.info("WAL force thread exits.");
                return;
            }
            for (WriteLogNode node : this.nodeMap.values()) {
                try {
                    node.forceSync();
                }
                catch (IOException e) {
                    logger.error("Cannot force {}, because ", (Object)node, (Object)e);
                }
            }
            try {
                Thread.sleep(this.config.getForceWalPeriodInMs());
            }
            catch (InterruptedException e) {
                logger.info("WAL force thread exits.");
                Thread.currentThread().interrupt();
                return;
            }
        }
    };

    private MultiFileLogNodeManager() {
        this.nodeMap = new ConcurrentHashMap<String, WriteLogNode>();
    }

    public static MultiFileLogNodeManager getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public WriteLogNode getNode(String identifier) {
        WriteLogNode oldNode;
        WriteLogNode node = this.nodeMap.get(identifier);
        if (node == null && (oldNode = this.nodeMap.putIfAbsent(identifier, node = new ExclusiveWriteLogNode(identifier))) != null) {
            return oldNode;
        }
        return node;
    }

    @Override
    public void deleteNode(String identifier) throws IOException {
        WriteLogNode node = this.nodeMap.remove(identifier);
        if (node != null) {
            node.delete();
        }
    }

    @Override
    public void close() {
        if (!this.isActivated(this.forceThread)) {
            logger.warn("MultiFileLogNodeManager has not yet started");
            return;
        }
        logger.info("LogNodeManager starts closing..");
        if (this.isActivated(this.forceThread)) {
            this.forceThread.interrupt();
            logger.info("Waiting for force thread to stop");
            while (this.forceThread.isAlive()) {
            }
        }
        logger.info("{} nodes to be closed", (Object)this.nodeMap.size());
        for (WriteLogNode node : this.nodeMap.values()) {
            try {
                node.close();
            }
            catch (IOException e) {
                logger.error("failed to close {}", (Object)node, (Object)e);
            }
        }
        this.nodeMap.clear();
        logger.info("LogNodeManager closed.");
    }

    @Override
    public void start() throws StartupException {
        try {
            if (!this.config.isEnableWal()) {
                return;
            }
            if (!this.isActivated(this.forceThread)) {
                if (this.config.getForceWalPeriodInMs() > 0L) {
                    InstanceHolder.instance.forceThread = new Thread(InstanceHolder.instance.forceTask, ThreadName.WAL_FORCE_DAEMON.getName());
                    InstanceHolder.instance.forceThread.start();
                }
            } else {
                logger.warn("MultiFileLogNodeManager has already started");
            }
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        if (!this.config.isEnableWal()) {
            return;
        }
        this.close();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.WAL_SERVICE;
    }

    private boolean isActivated(Thread thread) {
        return thread != null && thread.isAlive();
    }

    private static class InstanceHolder {
        private static MultiFileLogNodeManager instance = new MultiFileLogNodeManager();

        private InstanceHolder() {
        }
    }
}

