/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.List;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;

public class SchemaUtils {
    private SchemaUtils() {
    }

    public static Schema constructSchema(String processorName) {
        List<MeasurementSchema> columnSchemaList = MManager.getInstance().getSchemaForStorageGroup(processorName);
        return SchemaUtils.getSchemaFromColumnSchema(columnSchemaList);
    }

    public static Schema getSchemaFromColumnSchema(List<MeasurementSchema> schemaList) {
        Schema schema = new Schema();
        for (MeasurementSchema measurementSchema : schemaList) {
            schema.registerMeasurement(measurementSchema);
        }
        return schema;
    }
}

