/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class QueryDataSetUtils {
    private QueryDataSetUtils() {
    }

    public static TSQueryDataSet convertQueryDataSetByFetchSize(QueryDataSet queryDataSet, int fetchSize) throws IOException {
        return QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize, null);
    }

    public static TSQueryDataSet convertQueryDataSetByFetchSize(QueryDataSet queryDataSet, int fetchSize, WatermarkEncoder watermarkEncoder) throws IOException {
        List dataTypes = queryDataSet.getDataTypes();
        int columnNum = dataTypes.size();
        TSQueryDataSet tsQueryDataSet = new TSQueryDataSet();
        int columnNumWithTime = columnNum + 1;
        DataOutputStream[] dataOutputStreams = new DataOutputStream[columnNumWithTime];
        ByteArrayOutputStream[] byteArrayOutputStreams = new ByteArrayOutputStream[columnNumWithTime];
        for (int i = 0; i < columnNumWithTime; ++i) {
            byteArrayOutputStreams[i] = new ByteArrayOutputStream();
            dataOutputStreams[i] = new DataOutputStream(byteArrayOutputStreams[i]);
        }
        int rowCount = 0;
        int valueOccupation = 0;
        for (int i = 0; i < fetchSize && queryDataSet.hasNext(); ++i) {
            ++rowCount;
            RowRecord rowRecord = queryDataSet.next();
            if (watermarkEncoder != null) {
                rowRecord = watermarkEncoder.encodeRecord(rowRecord);
            }
            dataOutputStreams[0].writeLong(rowRecord.getTimestamp());
            List fields = rowRecord.getFields();
            block10: for (int k = 0; k < fields.size(); ++k) {
                Field field = (Field)fields.get(k);
                DataOutputStream dataOutputStream = dataOutputStreams[k + 1];
                if (field.getDataType() == null) {
                    dataOutputStream.writeBoolean(true);
                    continue;
                }
                dataOutputStream.writeBoolean(false);
                TSDataType type = field.getDataType();
                switch (type) {
                    case INT32: {
                        dataOutputStream.writeInt(field.getIntV());
                        valueOccupation += 4;
                        continue block10;
                    }
                    case INT64: {
                        dataOutputStream.writeLong(field.getLongV());
                        valueOccupation += 8;
                        continue block10;
                    }
                    case FLOAT: {
                        dataOutputStream.writeFloat(field.getFloatV());
                        valueOccupation += 4;
                        continue block10;
                    }
                    case DOUBLE: {
                        dataOutputStream.writeDouble(field.getDoubleV());
                        valueOccupation += 8;
                        continue block10;
                    }
                    case BOOLEAN: {
                        dataOutputStream.writeBoolean(field.getBoolV());
                        ++valueOccupation;
                        continue block10;
                    }
                    case TEXT: {
                        dataOutputStream.writeInt(field.getBinaryV().getLength());
                        dataOutputStream.write(field.getBinaryV().getValues());
                        valueOccupation = valueOccupation + 4 + field.getBinaryV().getLength();
                        continue block10;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                    }
                }
            }
        }
        valueOccupation += rowCount * 8;
        ByteBuffer valueBuffer = ByteBuffer.allocate(valueOccupation += rowCount * dataTypes.size());
        for (ByteArrayOutputStream byteArrayOutputStream : byteArrayOutputStreams) {
            valueBuffer.put(byteArrayOutputStream.toByteArray());
        }
        valueBuffer.flip();
        tsQueryDataSet.setValues(valueBuffer);
        tsQueryDataSet.setRowCount(rowCount);
        return tsQueryDataSet;
    }

    public static long[] readTimesFromBuffer(ByteBuffer buffer, int size) {
        long[] times = new long[size];
        for (int i = 0; i < size; ++i) {
            times[i] = buffer.getLong();
        }
        return times;
    }

    public static Object[] readValuesFromBuffer(ByteBuffer buffer, List<Integer> types, int columns, int size) {
        TSDataType[] dataTypes = new TSDataType[types.size()];
        for (int i = 0; i < dataTypes.length; ++i) {
            dataTypes[i] = TSDataType.values()[types.get(i)];
        }
        return QueryDataSetUtils.readValuesFromBuffer(buffer, dataTypes, columns, size);
    }

    public static Object[] readValuesFromBuffer(ByteBuffer buffer, TSDataType[] types, int columns, int size) {
        Object[] values = new Object[columns];
        block8: for (int i = 0; i < columns; ++i) {
            switch (types[i]) {
                case BOOLEAN: {
                    boolean[] boolValues = new boolean[size];
                    for (int index = 0; index < size; ++index) {
                        boolValues[index] = BytesUtils.byteToBool((byte)buffer.get());
                    }
                    values[i] = boolValues;
                    continue block8;
                }
                case INT32: {
                    int[] intValues = new int[size];
                    for (int index = 0; index < size; ++index) {
                        intValues[index] = buffer.getInt();
                    }
                    values[i] = intValues;
                    continue block8;
                }
                case INT64: {
                    long[] longValues = new long[size];
                    for (int index = 0; index < size; ++index) {
                        longValues[index] = buffer.getLong();
                    }
                    values[i] = longValues;
                    continue block8;
                }
                case FLOAT: {
                    float[] floatValues = new float[size];
                    for (int index = 0; index < size; ++index) {
                        floatValues[index] = buffer.getFloat();
                    }
                    values[i] = floatValues;
                    continue block8;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[size];
                    for (int index = 0; index < size; ++index) {
                        doubleValues[index] = buffer.getDouble();
                    }
                    values[i] = doubleValues;
                    continue block8;
                }
                case TEXT: {
                    Binary[] binaryValues = new Binary[size];
                    for (int index = 0; index < size; ++index) {
                        int binarySize = buffer.getInt();
                        byte[] binaryValue = new byte[binarySize];
                        buffer.get(binaryValue);
                        binaryValues[index] = new Binary(binaryValue);
                    }
                    values[i] = binaryValues;
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", types[i]));
                }
            }
        }
        return values;
    }
}

