/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;

public class CommonUtils {
    private CommonUtils() {
    }

    public static int getJdkVersion() {
        String[] javaVersionElements = System.getProperty("java.version").split("\\.");
        if (Integer.parseInt(javaVersionElements[0]) == 1) {
            return Integer.parseInt(javaVersionElements[1]);
        }
        return Integer.parseInt(javaVersionElements[0]);
    }

    public static long getUsableSpace(String dir) {
        return FSFactoryProducer.getFSFactory().getFile(dir).getFreeSpace();
    }

    public static boolean hasSpace(String dir) {
        return CommonUtils.getUsableSpace(dir) > 0L;
    }

    public static long getOccupiedSpace(String folderPath) throws IOException {
        Path folder = Paths.get(folderPath, new String[0]);
        return Files.walk(folder, new FileVisitOption[0]).filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
    }
}

