/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.watermark;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.thrift.EncodingUtils;

public class GroupedLSBWatermarkEncoder
implements WatermarkEncoder {
    private String secretKey;
    private String bitString;
    private int markRate = 2;
    private int groupNumber;
    private int maxBitPosition = 5;
    private int minBitPosition = 0;

    public GroupedLSBWatermarkEncoder(String secretKey, String bitString) {
        this.secretKey = secretKey;
        this.bitString = bitString;
        this.groupNumber = bitString.length();
    }

    public GroupedLSBWatermarkEncoder(IoTDBConfig conf) {
        this(conf.getWatermarkSecretKey(), conf.getWatermarkBitString());
        this.markRate = conf.getWatermarkParamMarkRate();
        this.maxBitPosition = conf.getWatermarkParamMaxRightBit();
    }

    public static int hashMod(String val, Integer base) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("ERROR: Cannot find MD5 algorithm!");
        }
        md.update(val.getBytes());
        BigInteger resultInteger = new BigInteger(1, md.digest());
        return resultInteger.mod(new BigInteger(base.toString())).intValue();
    }

    private boolean getMarkFlag(long timestamp) {
        return GroupedLSBWatermarkEncoder.hashMod(String.format("%s%d", this.secretKey, timestamp), this.markRate) == 0;
    }

    private int getGroupId(long timestamp) {
        return GroupedLSBWatermarkEncoder.hashMod(String.format("%d%s", timestamp, this.secretKey), this.groupNumber);
    }

    private int getBitPosition(long timestamp) {
        if (this.maxBitPosition <= this.minBitPosition) {
            throw new RuntimeException("Error: minBitPosition is bigger than maxBitPosition");
        }
        int range = this.maxBitPosition - this.minBitPosition;
        return this.minBitPosition + GroupedLSBWatermarkEncoder.hashMod(String.format("%s%d%s", this.secretKey, timestamp, this.secretKey), range);
    }

    private boolean getBitValue(long timestamp) {
        int groupId = this.getGroupId(timestamp);
        int bitIndex = groupId % this.bitString.length();
        return this.bitString.charAt(bitIndex) == '1';
    }

    private int encodeInt(int value, long timestamp) {
        int targetBitPosition = this.getBitPosition(timestamp);
        boolean targetBitValue = this.getBitValue(timestamp);
        return EncodingUtils.setBit((int)value, (int)targetBitPosition, (boolean)targetBitValue);
    }

    private long encodeLong(long value, long timestamp) {
        int targetBitPosition = this.getBitPosition(timestamp);
        boolean targetBitValue = this.getBitValue(timestamp);
        return EncodingUtils.setBit((long)value, (int)targetBitPosition, (boolean)targetBitValue);
    }

    private float encodeFloat(float value, long timestamp) {
        int intBits = Float.floatToIntBits(value);
        return Float.intBitsToFloat(this.encodeInt(intBits, timestamp));
    }

    private double encodeDouble(double value, long timestamp) {
        long longBits = Double.doubleToLongBits(value);
        return Double.longBitsToDouble(this.encodeLong(longBits, timestamp));
    }

    @Override
    public RowRecord encodeRecord(RowRecord record) {
        long timestamp = record.getTimestamp();
        if (!this.getMarkFlag(timestamp)) {
            return record;
        }
        List fields = record.getFields();
        for (Field field : fields) {
            if (field.getDataType() == null) continue;
            TSDataType dataType = field.getDataType();
            switch (dataType) {
                case INT32: {
                    int originIntValue = field.getIntV();
                    field.setIntV(this.encodeInt(originIntValue, timestamp));
                    break;
                }
                case INT64: {
                    long originLongValue = field.getLongV();
                    field.setLongV(this.encodeLong(originLongValue, timestamp));
                    break;
                }
                case FLOAT: {
                    float originFloatValue = field.getFloatV();
                    field.setFloatV(this.encodeFloat(originFloatValue, timestamp));
                    break;
                }
                case DOUBLE: {
                    double originDoubleValue = field.getDoubleV();
                    field.setDoubleV(this.encodeDouble(originDoubleValue, timestamp));
                    break;
                }
            }
        }
        return record;
    }
}

