/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.upgrade;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.tool.upgrade.UpgradeTool;

public class OfflineUpgradeTool {
    private static List<String> oldVersionTsfileDirs = new ArrayList<String>();
    private static List<String> newVersionTsfileDirs = new ArrayList<String>();
    private static int upgradeThreadNum;

    private static void loadProps(String configPath) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(FSFactoryProducer.getFSFactory().getFile(configPath));
        }
        catch (FileNotFoundException e) {
            System.out.println(String.format("Fail to find config file:%s", configPath));
            e.printStackTrace();
            System.exit(1);
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            String oldVersionTsfileDirString = properties.getProperty("old_version_data_dirs");
            Collections.addAll(oldVersionTsfileDirs, oldVersionTsfileDirString.split(","));
            String newVersionTsfileDirString = properties.getProperty("new_version_data_dirs");
            Collections.addAll(newVersionTsfileDirs, newVersionTsfileDirString.split(","));
            upgradeThreadNum = Integer.parseInt(properties.getProperty("upgrade_thread_num"));
        }
        catch (IOException e) {
            System.out.println("Cannot load config file ");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        OfflineUpgradeTool.loadProps(args[0]);
        for (int i = 0; i < oldVersionTsfileDirs.size(); ++i) {
            UpgradeTool.upgradeTsfiles((String)oldVersionTsfileDirs.get(i), (String)newVersionTsfileDirs.get(i), (int)upgradeThreadNum);
        }
    }
}

