/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual.gui;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

class FileSelectionBox
extends Box {
    private JLabel panelName;
    private JTextField filePathField;
    private JButton selectFileButton;
    private FilePathBoxSelectionCallBack callBack;
    private int selectionMode;

    FileSelectionBox(String name, FilePathBoxSelectionCallBack callBack, String defaultFilePath, int selectionMode) {
        super(0);
        this.callBack = callBack;
        this.selectionMode = selectionMode;
        this.panelName = new JLabel(name);
        this.filePathField = new JTextField("No file is selected");
        this.filePathField.setEditable(false);
        this.selectFileButton = new JButton("Select");
        this.selectFileButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSelectionBox.this.onSelectFileButtonClick();
            }
        });
        Box vBox = Box.createVerticalBox();
        vBox.add(this.panelName);
        vBox.add(this.filePathField);
        this.add(vBox);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.selectFileButton);
        if (defaultFilePath != null) {
            File defaultFile = new File(defaultFilePath);
            if (!defaultFile.exists()) {
                JOptionPane.showMessageDialog(this, this.panelName.getText() + ":default file " + defaultFilePath + " does not exist");
            } else {
                this.filePathField.setText(defaultFilePath);
                callBack.call(defaultFile);
            }
        }
    }

    private void onSelectFileButtonClick() {
        int status;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(this.selectionMode);
        File currentFile = new File(this.filePathField.getText());
        if (currentFile.exists()) {
            if (currentFile.isDirectory()) {
                fileChooser.setCurrentDirectory(currentFile);
            } else {
                fileChooser.setCurrentDirectory(currentFile.getParentFile());
            }
        }
        if ((status = fileChooser.showOpenDialog(this)) == 0) {
            File chosenFile = fileChooser.getSelectedFile();
            this.callBack.call(chosenFile);
            this.filePathField.setText(chosenFile.getPath());
        }
    }

    static interface FilePathBoxSelectionCallBack {
        public void call(File var1);
    }
}

