/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.tools.logvisual.LogEntry;
import org.apache.iotdb.db.tools.logvisual.LogFilter;
import org.apache.iotdb.db.tools.logvisual.VisualUtils;
import org.apache.iotdb.db.tools.logvisual.exceptions.UnmatchedContentException;

public class VisualizationPlan {
    private String name = "untitled";
    private Pattern contentPattern;
    private int[] measurementPositions;
    private String[] legends;
    private int[] tagPositions;
    private LogFilter logFilter;
    private String planFilePath;

    public VisualizationPlan() {
        this.logFilter = new LogFilter();
    }

    VisualizationPlan(String planFilePath) throws IOException {
        this.planFilePath = planFilePath;
        Properties properties = new Properties();
        try (FileInputStream reader = new FileInputStream(planFilePath);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(reader);){
            properties.load(bufferedInputStream);
        }
        this.name = properties.getProperty(PlanProperties.NAME.getPropertyName(), "untitled");
        String patternStr = properties.getProperty(PlanProperties.CONTENT_PATTERN.getPropertyName());
        if (patternStr == null) {
            throw new IOException("Bad plan, content pattern unset");
        }
        this.contentPattern = Pattern.compile(patternStr);
        this.measurementPositions = VisualUtils.parseIntArray(properties.getProperty(PlanProperties.MEASUREMENT_POSITIONS.getPropertyName()));
        String legendStr = properties.getProperty(PlanProperties.LEGENDS.getPropertyName());
        if (legendStr != null) {
            this.legends = legendStr.split(",");
        }
        if (this.measurementPositions != null && (this.legends == null || this.legends.length != this.measurementPositions.length)) {
            throw new IOException("Bad plan, the number of legends is different from the number of measurements");
        }
        this.tagPositions = VisualUtils.parseIntArray(properties.getProperty(PlanProperties.TAG_POSITIONS.getPropertyName()));
        this.logFilter = new LogFilter(properties);
    }

    public void parseContents(LogEntry logEntry) throws UnmatchedContentException {
        Matcher matcher = this.contentPattern.matcher(logEntry.getLogContent());
        if (!matcher.matches()) {
            throw new UnmatchedContentException(logEntry.getLogContent(), this.contentPattern.pattern());
        }
        String[] matchedValues = new String[matcher.groupCount()];
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            matchedValues[i - 1] = matcher.group(i);
        }
        if (this.tagPositions != null) {
            ArrayList<String> tags = new ArrayList<String>();
            for (int pos : this.tagPositions) {
                tags.add(matchedValues[pos - 1]);
            }
            logEntry.setTags(tags);
        }
        if (this.measurementPositions != null) {
            ArrayList<Double> measurements = new ArrayList<Double>();
            for (int pos : this.measurementPositions) {
                measurements.add(Double.parseDouble(matchedValues[pos - 1]));
            }
            logEntry.setMeasurements(measurements);
        }
    }

    public String getName() {
        return this.name;
    }

    public Pattern getContentPattern() {
        return this.contentPattern;
    }

    public int[] getMeasurementPositions() {
        return this.measurementPositions;
    }

    public String[] getLegends() {
        return this.legends;
    }

    public int[] getTagPositions() {
        return this.tagPositions;
    }

    public LogFilter getLogFilter() {
        return this.logFilter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContentPattern(Pattern contentPattern) {
        this.contentPattern = contentPattern;
    }

    public void setMeasurementPositions(int[] measurementPositions) {
        this.measurementPositions = measurementPositions;
    }

    public void setLegends(String[] legends) {
        this.legends = legends;
    }

    public void setTagPositions(int[] tagPositions) {
        this.tagPositions = tagPositions;
    }

    public void setPlanFilePath(String planFilePath) {
        this.planFilePath = planFilePath;
    }

    public String getPlanFilePath() {
        return this.planFilePath;
    }

    public String toString() {
        return this.name;
    }

    public void saveAsFile() throws IOException {
        Properties properties = this.saveAsProperties();
        this.logFilter.saveIntoProperties(properties);
        try (FileWriter fileWriter = new FileWriter(this.planFilePath);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            properties.store(bufferedWriter, "");
        }
    }

    private Properties saveAsProperties() {
        Properties properties = new Properties();
        properties.put(PlanProperties.NAME.getPropertyName(), this.name);
        properties.put(PlanProperties.CONTENT_PATTERN.getPropertyName(), this.contentPattern.pattern());
        if (this.measurementPositions != null) {
            properties.put(PlanProperties.MEASUREMENT_POSITIONS.getPropertyName(), VisualUtils.intArrayToString(this.measurementPositions));
        }
        if (this.legends != null) {
            properties.put(PlanProperties.LEGENDS.getPropertyName(), String.join((CharSequence)",", this.legends));
        }
        if (this.tagPositions != null) {
            properties.put(PlanProperties.TAG_POSITIONS.getPropertyName(), VisualUtils.intArrayToString(this.tagPositions));
        }
        return properties;
    }

    static enum PlanProperties {
        NAME("name"),
        CONTENT_PATTERN("content_pattern"),
        MEASUREMENT_POSITIONS("measurement_positions"),
        LEGENDS("legends"),
        TAG_POSITIONS("tag_positions");

        private String propertyName;

        private PlanProperties(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

