/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual;

import java.util.Collections;
import java.util.Date;
import java.util.List;

public class LogEntry {
    private static List<String> DEFAULT_TAG = Collections.EMPTY_LIST;
    private Date date;
    private String threadName;
    private LogLevel logLevel;
    private CodeLocation codeLocation;
    private String logContent;
    private List<String> tags = DEFAULT_TAG;
    private List<Double> measurements;

    LogEntry(Date date, String threadName, LogLevel logLevel, CodeLocation codeLocation, String logContent) {
        this.date = date;
        this.threadName = threadName;
        this.logLevel = logLevel;
        this.codeLocation = codeLocation;
        this.logContent = logContent;
    }

    public Date getDate() {
        return this.date;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public CodeLocation getCodeLocation() {
        return this.codeLocation;
    }

    public String getLogContent() {
        return this.logContent;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<Double> getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(List<Double> measurements) {
        this.measurements = measurements;
    }

    static class CodeLocation {
        private String className;
        private int lineNum;

        CodeLocation(String className, int lineNum) {
            this.className = className;
            this.lineNum = lineNum;
        }

        public String getClassName() {
            return this.className;
        }

        public int getLineNum() {
            return this.lineNum;
        }
    }

    public static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

