/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.MemEst;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.IoTDBConfigDynamicAdapter;
import org.apache.iotdb.db.exception.ConfigAdjusterException;
import org.apache.iotdb.db.metadata.MManager;

@Command(name="calmem", description="calculate minimum memory required for writing based on the number of storage groups and timeseries")
public class MemEstToolCmd
implements Runnable {
    @Option(title="storage group number", name={"-sg", "--storagegroup"}, description="Storage group number")
    private String sgNumString = "10";
    @Option(title="total timeseries number", name={"-ts", "--timeseries"}, description="Total timeseries number")
    private String tsNumString = "1000";
    @Option(title="max timeseries", name={"-mts", "--maxtimeseries"}, description="Maximum timeseries number among storage groups, make sure that it's smaller than total timeseries number")
    private String maxTsNumString = "0";

    @Override
    public void run() {
        long stepMemory;
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        long memTableSize = config.getMemtableSizeThreshold();
        int maxMemtableNumber = config.getMaxMemtableNumber();
        long tsFileSize = config.getTsFileSizeThreshold();
        long sgNum = Long.parseLong(this.sgNumString);
        long tsNum = Long.parseLong(this.tsNumString);
        long maxTsNum = Long.parseLong(this.maxTsNumString);
        long currentMemory = stepMemory = this.calStepMemory(tsNum) * 0x40000000L;
        long maxTsNumValid = maxTsNum;
        long maxProcess = 0L;
        long start = System.currentTimeMillis();
        while (true) {
            long sgCnt;
            config.setAllocateMemoryForWrite(currentMemory);
            config.setMemtableSizeThreshold(memTableSize);
            config.setMaxMemtableNumber(maxMemtableNumber);
            config.setTsFileSizeThreshold(tsFileSize);
            IoTDBConfigDynamicAdapter.getInstance().reset();
            IoTDBConfigDynamicAdapter.getInstance().setInitialized(true);
            MManager.getInstance().clear();
            long tsCnt = 0L;
            try {
                for (sgCnt = 1L; sgCnt <= sgNum; ++sgCnt) {
                    IoTDBConfigDynamicAdapter.getInstance().addOrDeleteStorageGroup(1);
                }
                while (tsCnt < tsNum) {
                    IoTDBConfigDynamicAdapter.getInstance().addOrDeleteTimeSeries(1);
                    if (maxTsNum == 0L) {
                        maxTsNumValid = tsCnt / sgNum + 1L;
                    } else {
                        maxTsNumValid = Math.min(tsCnt, maxTsNum);
                        maxTsNumValid = Math.max(maxTsNumValid, tsCnt / sgNum + 1L);
                    }
                    MManager.getInstance().setMaxSeriesNumberAmongStorageGroup(maxTsNumValid);
                    ++tsCnt;
                }
            }
            catch (ConfigAdjusterException e) {
                if (sgCnt > sgNum) {
                    maxProcess = Math.max(maxProcess, (tsCnt + 1L) * 100L / tsNum);
                    System.out.print(String.format("Memory estimation progress : %d%%\r", maxProcess));
                }
                currentMemory += stepMemory;
                continue;
            }
            break;
        }
        System.out.println(String.format("Memory for writing: %dGB, SG: %d, TS: %d, MTS: %d", currentMemory / 0x40000000L, sgNum, tsNum, maxTsNumValid));
        System.out.println(String.format("Calculating memory for writing consumes: %dms", System.currentTimeMillis() - start));
    }

    private long calStepMemory(long maxTimeseriesNumber) {
        maxTimeseriesNumber /= 10000000L;
        int step = 1;
        while (maxTimeseriesNumber > 0L) {
            maxTimeseriesNumber /= 10L;
            step *= 10;
        }
        return step;
    }
}

