/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.timegenerator;

import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.AndNode;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.OrNode;

public abstract class AbstractNodeConstructor {
    public abstract Node construct(IExpression var1, QueryContext var2) throws StorageEngineException;

    protected Node constructNotSeriesNode(IExpression expression, QueryContext context) throws StorageEngineException {
        if (expression.getType() == ExpressionType.OR) {
            Node leftChild = this.construct(((IBinaryExpression)expression).getLeft(), context);
            Node rightChild = this.construct(((IBinaryExpression)expression).getRight(), context);
            return new OrNode(leftChild, rightChild);
        }
        if (expression.getType() == ExpressionType.AND) {
            Node leftChild = this.construct(((IBinaryExpression)expression).getLeft(), context);
            Node rightChild = this.construct(((IBinaryExpression)expression).getRight(), context);
            return new AndNode(leftChild, rightChild);
        }
        throw new UnSupportedDataTypeException("Unsupported QueryFilterType when construct OperatorNode: " + expression.getType());
    }
}

