/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.universal;

import java.io.IOException;
import org.apache.iotdb.db.query.reader.IAggregateReader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.read.common.BatchData;

public abstract class IterateReader
implements IAggregateReader {
    protected IAggregateReader currentSeriesReader;
    private boolean curReaderInitialized = false;
    private int nextSeriesReaderIndex = 0;
    private int readerSize;

    public IterateReader(int readerSize) {
        this.readerSize = readerSize;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.curReaderInitialized && this.currentSeriesReader.hasNext()) {
            return true;
        }
        this.curReaderInitialized = false;
        while (this.nextSeriesReaderIndex < this.readerSize) {
            boolean isConstructed;
            if (!(isConstructed = this.constructNextReader(this.nextSeriesReaderIndex++)) || !this.currentSeriesReader.hasNext()) continue;
            this.curReaderInitialized = true;
            return true;
        }
        return false;
    }

    protected abstract boolean constructNextReader(int var1) throws IOException;

    @Override
    public BatchData nextBatch() throws IOException {
        return this.currentSeriesReader.nextBatch();
    }

    @Override
    public PageHeader nextPageHeader() throws IOException {
        return this.currentSeriesReader.nextPageHeader();
    }

    @Override
    public void skipPageData() throws IOException {
        this.currentSeriesReader.skipPageData();
    }

    @Override
    public void close() {
    }
}

