/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.resourceRelated;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.engine.cache.DeviceMetaDataCache;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.externalsort.SimpleExternalSortEngine;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.chunkRelated.ChunkReaderWrap;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReaderByTimestamp;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;

public class UnseqResourceReaderByTimestamp
extends PriorityMergeReaderByTimestamp {
    private long queryId;

    public UnseqResourceReaderByTimestamp(Path seriesPath, List<TsFileResource> unseqResources, QueryContext context) throws IOException {
        this.queryId = context.getJobId();
        ArrayList<ChunkReaderWrap> chunkReaderWrapList = new ArrayList<ChunkReaderWrap>();
        for (TsFileResource tsFileResource : unseqResources) {
            List<ChunkMetaData> metaDataList;
            if (tsFileResource.isClosed()) {
                metaDataList = DeviceMetaDataCache.getInstance().get(tsFileResource, seriesPath);
                List<Modification> pathModifications = context.getPathModifications(tsFileResource.getModFile(), seriesPath.getFullPath());
                if (!pathModifications.isEmpty()) {
                    QueryUtils.modifyChunkMetaData(metaDataList, pathModifications);
                }
            } else {
                metaDataList = tsFileResource.getChunkMetaDataList();
            }
            ChunkLoaderImpl chunkLoader = null;
            if (!metaDataList.isEmpty()) {
                TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(tsFileResource, tsFileResource.isClosed());
                chunkLoader = new ChunkLoaderImpl(tsFileReader);
            }
            for (ChunkMetaData chunkMetaData : metaDataList) {
                chunkReaderWrapList.add(new ChunkReaderWrap(chunkMetaData, (IChunkLoader)chunkLoader, null));
            }
            if (tsFileResource.isClosed()) continue;
            chunkReaderWrapList.add(new ChunkReaderWrap(tsFileResource.getReadOnlyMemChunk(), null));
        }
        SimpleExternalSortEngine externalSortJobEngine = SimpleExternalSortEngine.getInstance();
        List<IReaderByTimestamp> readerList = externalSortJobEngine.executeForByTimestampReader(this.queryId, chunkReaderWrapList);
        int priorityValue = 1;
        for (IReaderByTimestamp chunkReader : readerList) {
            this.addReaderWithPriority(chunkReader, priorityValue++);
        }
    }
}

