/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.resourceRelated;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.engine.cache.DeviceMetaDataCache;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.externalsort.SimpleExternalSortEngine;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.chunkRelated.ChunkReaderWrap;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDigest;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.DigestForFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class UnseqResourceMergeReader
extends PriorityMergeReader {
    private Path seriesPath;
    private long queryId;

    public UnseqResourceMergeReader(Path seriesPath, List<TsFileResource> unseqResources, QueryContext context, Filter filter) throws IOException {
        this.seriesPath = seriesPath;
        this.queryId = context.getJobId();
        ArrayList<ChunkReaderWrap> readerWrapList = new ArrayList<ChunkReaderWrap>();
        for (TsFileResource tsFileResource : unseqResources) {
            List<ChunkMetaData> metaDataList;
            if (tsFileResource.isClosed()) {
                if (this.isTsFileNotSatisfied(tsFileResource, filter)) continue;
                metaDataList = DeviceMetaDataCache.getInstance().get(tsFileResource, seriesPath);
                List<Modification> pathModifications = context.getPathModifications(tsFileResource.getModFile(), seriesPath.getFullPath());
                if (!pathModifications.isEmpty()) {
                    QueryUtils.modifyChunkMetaData(metaDataList, pathModifications);
                }
            } else {
                if (tsFileResource.getEndTimeMap().size() != 0 && this.isTsFileNotSatisfied(tsFileResource, filter)) continue;
                metaDataList = tsFileResource.getChunkMetaDataList();
            }
            ChunkLoaderImpl chunkLoader = null;
            if (!metaDataList.isEmpty()) {
                TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(tsFileResource, tsFileResource.isClosed());
                chunkLoader = new ChunkLoaderImpl(tsFileReader);
            }
            for (ChunkMetaData chunkMetaData : metaDataList) {
                if (filter != null) {
                    DigestForFilter digest;
                    ByteBuffer minValue = null;
                    ByteBuffer maxValue = null;
                    ByteBuffer[] statistics = chunkMetaData.getDigest().getStatistics();
                    if (statistics != null) {
                        minValue = statistics[TsDigest.StatisticType.min_value.ordinal()];
                        maxValue = statistics[TsDigest.StatisticType.max_value.ordinal()];
                    }
                    if (!filter.satisfy(digest = new DigestForFilter(chunkMetaData.getStartTime(), chunkMetaData.getEndTime(), minValue, maxValue, chunkMetaData.getTsDataType()))) continue;
                }
                readerWrapList.add(new ChunkReaderWrap(chunkMetaData, (IChunkLoader)chunkLoader, filter));
            }
            if (tsFileResource.isClosed()) continue;
            readerWrapList.add(new ChunkReaderWrap(tsFileResource.getReadOnlyMemChunk(), filter));
        }
        SimpleExternalSortEngine externalSortJobEngine = SimpleExternalSortEngine.getInstance();
        List<IPointReader> readerList = externalSortJobEngine.executeForIPointReader(this.queryId, readerWrapList);
        int priorityValue = 1;
        for (IPointReader chunkReader : readerList) {
            this.addReaderWithPriority(chunkReader, priorityValue++);
        }
    }

    private boolean isTsFileNotSatisfied(TsFileResource tsFile, Filter filter) {
        long endTime;
        if (filter == null) {
            return false;
        }
        long startTime = tsFile.getStartTimeMap().get(this.seriesPath.getDevice());
        return !filter.satisfyStartEndTime(startTime, endTime = tsFile.getEndTimeMap().get(this.seriesPath.getDevice()).longValue());
    }
}

