/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.fileRelated;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.IAggregateReader;
import org.apache.iotdb.db.query.reader.chunkRelated.MemChunkReader;
import org.apache.iotdb.db.query.reader.fileRelated.FileSeriesReaderAdapter;
import org.apache.iotdb.db.query.reader.universal.IterateReader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReader;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderWithFilter;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderWithoutFilter;

public class UnSealedTsFileIterateReader
extends IterateReader {
    private TsFileResource unsealedTsFile;
    private Filter filter;
    private boolean enableReverse;

    public UnSealedTsFileIterateReader(TsFileResource unsealedTsFile, Filter filter, boolean isReverse) {
        super(2);
        this.enableReverse = isReverse;
        this.unsealedTsFile = unsealedTsFile;
        this.filter = filter;
    }

    @Override
    protected boolean constructNextReader(int idx) throws IOException {
        this.currentSeriesReader = idx == 0 ? (this.enableReverse ? new MemChunkReader(this.unsealedTsFile.getReadOnlyMemChunk(), this.filter) : this.initUnSealedTsFileDiskReader(this.unsealedTsFile, this.filter)) : (this.enableReverse ? this.initUnSealedTsFileDiskReader(this.unsealedTsFile, this.filter) : new MemChunkReader(this.unsealedTsFile.getReadOnlyMemChunk(), this.filter));
        return true;
    }

    private IAggregateReader initUnSealedTsFileDiskReader(TsFileResource unSealedTsFile, Filter filter) throws IOException {
        Object fileSeriesReader;
        List<ChunkMetaData> metaDataList = unSealedTsFile.getChunkMetaDataList();
        if (metaDataList == null || metaDataList.isEmpty()) {
            fileSeriesReader = filter == null ? new FileSeriesReaderWithoutFilter(null, metaDataList) : new FileSeriesReaderWithFilter(null, metaDataList, filter);
        } else {
            if (this.enableReverse) {
                Collections.reverse(metaDataList);
            }
            TsFileSequenceReader unClosedTsFileReader = FileReaderManager.getInstance().get(unSealedTsFile, false);
            ChunkLoaderImpl chunkLoader = new ChunkLoaderImpl(unClosedTsFileReader);
            fileSeriesReader = filter == null ? new FileSeriesReaderWithoutFilter((IChunkLoader)chunkLoader, metaDataList) : new FileSeriesReaderWithFilter((IChunkLoader)chunkLoader, metaDataList, filter);
        }
        return new FileSeriesReaderAdapter((FileSeriesReader)fileSeriesReader);
    }
}

