/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;

public class JobFileManager {
    private Map<Long, Set<TsFileResource>> sealedFilePathsMap = new ConcurrentHashMap<Long, Set<TsFileResource>>();
    private Map<Long, Set<TsFileResource>> unsealedFilePathsMap = new ConcurrentHashMap<Long, Set<TsFileResource>>();

    JobFileManager() {
    }

    void addJobId(long jobId) {
        this.sealedFilePathsMap.computeIfAbsent(jobId, x -> new HashSet());
        this.unsealedFilePathsMap.computeIfAbsent(jobId, x -> new HashSet());
    }

    public void addUsedFilesForGivenJob(long jobId, QueryDataSource dataSource) {
        this.addUsedFilesForGivenJob(jobId, dataSource.getSeqResources());
        this.addUsedFilesForGivenJob(jobId, dataSource.getUnseqResources());
    }

    private void addUsedFilesForGivenJob(long jobId, List<TsFileResource> resources) {
        for (TsFileResource tsFileResource : resources) {
            boolean isClosed = tsFileResource.isClosed();
            this.addFilePathToMap(jobId, tsFileResource, isClosed);
            if (!tsFileResource.isDeleted()) continue;
            Map<Long, Set<TsFileResource>> pathMap = !isClosed ? this.unsealedFilePathsMap : this.sealedFilePathsMap;
            pathMap.get(jobId).remove(tsFileResource);
            FileReaderManager.getInstance().decreaseFileReaderReference(tsFileResource, isClosed);
            resources.remove(tsFileResource);
        }
    }

    void removeUsedFilesForGivenJob(long jobId) {
        Set<TsFileResource> tsFiles = this.sealedFilePathsMap.get(jobId);
        if (tsFiles != null) {
            for (TsFileResource tsFile : this.sealedFilePathsMap.get(jobId)) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, true);
            }
            this.sealedFilePathsMap.remove(jobId);
        }
        if ((tsFiles = this.unsealedFilePathsMap.get(jobId)) != null) {
            for (TsFileResource tsFile : this.unsealedFilePathsMap.get(jobId)) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, false);
            }
            this.unsealedFilePathsMap.remove(jobId);
        }
    }

    void addFilePathToMap(long jobId, TsFileResource tsFile, boolean isClosed) {
        Map<Long, Set<TsFileResource>> pathMap;
        Map<Long, Set<TsFileResource>> map = pathMap = isClosed ? this.unsealedFilePathsMap : this.sealedFilePathsMap;
        if (!pathMap.get(jobId).contains(tsFile)) {
            pathMap.get(jobId).add(tsFile);
            FileReaderManager.getInstance().increaseFileReaderReference(tsFile, isClosed);
        }
    }
}

