/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.UnClosedTsFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(FileReaderManager.class);
    private static final int MAX_CACHED_FILE_SIZE = 30000;
    private Map<TsFileResource, TsFileSequenceReader> closedFileReaderMap = new ConcurrentHashMap<TsFileResource, TsFileSequenceReader>();
    private Map<TsFileResource, TsFileSequenceReader> unclosedFileReaderMap = new ConcurrentHashMap<TsFileResource, TsFileSequenceReader>();
    private Map<TsFileResource, AtomicInteger> closedReferenceMap = new ConcurrentHashMap<TsFileResource, AtomicInteger>();
    private Map<TsFileResource, AtomicInteger> unclosedReferenceMap = new ConcurrentHashMap<TsFileResource, AtomicInteger>();
    private ScheduledExecutorService executorService = IoTDBThreadPoolFactory.newScheduledThreadPool(1, "open-files-manager");

    private FileReaderManager() {
        this.clearUnUsedFilesInFixTime();
    }

    public static FileReaderManager getInstance() {
        return FileReaderManagerHelper.INSTANCE;
    }

    public synchronized void closeFileAndRemoveReader(TsFileResource seqFile) throws IOException {
        this.closedReferenceMap.remove(seqFile);
        TsFileSequenceReader reader = this.closedFileReaderMap.remove(seqFile);
        if (reader != null) {
            reader.close();
        }
        this.unclosedReferenceMap.remove(seqFile);
        reader = this.unclosedFileReaderMap.remove(seqFile);
        if (reader != null) {
            reader.close();
        }
    }

    private void clearUnUsedFilesInFixTime() {
        long examinePeriod = IoTDBDescriptor.getInstance().getConfig().getCacheFileReaderClearPeriod();
        this.executorService.scheduleAtFixedRate(() -> {
            FileReaderManager fileReaderManager = this;
            synchronized (fileReaderManager) {
                this.clearMap(this.closedFileReaderMap, this.closedReferenceMap);
                this.clearMap(this.unclosedFileReaderMap, this.unclosedReferenceMap);
            }
        }, 0L, examinePeriod, TimeUnit.MILLISECONDS);
    }

    private void clearMap(Map<TsFileResource, TsFileSequenceReader> readerMap, Map<TsFileResource, AtomicInteger> refMap) {
        for (Map.Entry<TsFileResource, TsFileSequenceReader> entry : readerMap.entrySet()) {
            TsFileSequenceReader reader = entry.getValue();
            AtomicInteger refAtom = refMap.get(entry.getKey());
            if (refAtom == null || refAtom.get() != 0) continue;
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error("Can not close TsFileSequenceReader {} !", (Object)reader.getFileName(), (Object)e);
            }
            readerMap.remove(entry.getKey());
            refMap.remove(entry.getKey());
        }
    }

    public synchronized TsFileSequenceReader get(TsFileResource tsFile, boolean isClosed) throws IOException {
        Map<TsFileResource, TsFileSequenceReader> readerMap;
        Map<TsFileResource, TsFileSequenceReader> map = readerMap = !isClosed ? this.unclosedFileReaderMap : this.closedFileReaderMap;
        if (!readerMap.containsKey(tsFile)) {
            if (readerMap.size() >= 30000) {
                logger.warn("Query has opened {} files !", (Object)readerMap.size());
            }
            UnClosedTsFileReader tsFileReader = !isClosed ? new UnClosedTsFileReader(tsFile.getFile().getPath()) : new TsFileSequenceReader(tsFile.getFile().getPath());
            readerMap.put(tsFile, (TsFileSequenceReader)tsFileReader);
            return tsFileReader;
        }
        return readerMap.get(tsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseFileReaderReference(TsFileResource tsFile, boolean isClosed) {
        tsFile.getWriteQueryLock().readLock().lock();
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (!isClosed) {
                this.unclosedReferenceMap.computeIfAbsent(tsFile, k -> new AtomicInteger()).getAndIncrement();
            } else {
                this.closedReferenceMap.computeIfAbsent(tsFile, k -> new AtomicInteger()).getAndIncrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decreaseFileReaderReference(TsFileResource tsFile, boolean isClosed) {
        FileReaderManager fileReaderManager = this;
        synchronized (fileReaderManager) {
            if (!isClosed && this.unclosedReferenceMap.containsKey(tsFile)) {
                this.unclosedReferenceMap.get(tsFile).getAndDecrement();
            } else if (this.closedReferenceMap.containsKey(tsFile)) {
                this.closedReferenceMap.get(tsFile).getAndDecrement();
            }
        }
        tsFile.getWriteQueryLock().readLock().unlock();
    }

    public synchronized void closeAndRemoveAllOpenedReaders() throws IOException {
        for (Map.Entry<TsFileResource, TsFileSequenceReader> entry : this.closedFileReaderMap.entrySet()) {
            entry.getValue().close();
            this.closedReferenceMap.remove(entry.getKey());
            this.closedFileReaderMap.remove(entry.getKey());
        }
        for (Map.Entry<TsFileResource, TsFileSequenceReader> entry : this.unclosedFileReaderMap.entrySet()) {
            entry.getValue().close();
            this.unclosedReferenceMap.remove(entry.getKey());
            this.unclosedFileReaderMap.remove(entry.getKey());
        }
    }

    public synchronized boolean contains(TsFileResource tsFile, boolean isClosed) {
        return isClosed && this.closedFileReaderMap.containsKey(tsFile) || !isClosed && this.unclosedFileReaderMap.containsKey(tsFile);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            return;
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("StatMonitor timing service could not be shutdown.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.FILE_READER_MANAGER_SERVICE;
    }

    private static class FileReaderManagerHelper {
        private static final FileReaderManager INSTANCE = new FileReaderManager();

        private FileReaderManagerHelper() {
        }
    }
}

