/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public abstract class AggregateFunction {
    protected AggreResultData resultData;
    private TSDataType resultDataType;

    public AggregateFunction(TSDataType dataType) {
        this.resultDataType = dataType;
        this.resultData = new AggreResultData(dataType);
    }

    public abstract void init();

    public abstract AggreResultData getResult();

    public abstract void calculateValueFromPageHeader(PageHeader var1) throws QueryProcessException;

    public abstract void calculateValueFromPageData(BatchData var1, IPointReader var2) throws IOException;

    public abstract void calculateValueFromPageData(BatchData var1, IPointReader var2, long var3) throws IOException, QueryProcessException;

    public abstract void calculateValueFromUnsequenceReader(IPointReader var1) throws IOException, QueryProcessException;

    public abstract void calculateValueFromUnsequenceReader(IPointReader var1, long var2) throws IOException, QueryProcessException;

    public abstract void calcAggregationUsingTimestamps(long[] var1, int var2, IReaderByTimestamp var3) throws IOException;

    public abstract boolean isCalculatedAggregationResult();

    public TSDataType getResultDataType() {
        return this.resultDataType;
    }
}

