/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import org.antlr.runtime.Token;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.IllegalASTFormatException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.constant.DatetimeUtils;
import org.apache.iotdb.db.qp.constant.TqlParserConstant;
import org.apache.iotdb.db.qp.logical.RootOperator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.logical.crud.UpdateOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.DataAuthOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.PropertyOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTTLOperator;
import org.apache.iotdb.db.query.fill.IFill;
import org.apache.iotdb.db.query.fill.LinearFill;
import org.apache.iotdb.db.query.fill.PreviousFill;
import org.apache.iotdb.db.sql.parse.AstNode;
import org.apache.iotdb.db.sql.parse.Node;
import org.apache.iotdb.db.sql.parse.TqlParser;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class LogicalGenerator {
    private static final String INCORRECT_AUTHOR_COMMAND = "grant author";
    private static final String UPDATE_PASSWORD_COMMAND = "update password";
    private static final String DATA_LOAD_COMMAND = "data load";
    private RootOperator initializedOperator = null;
    private ZoneId zoneId;

    public LogicalGenerator(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public RootOperator getLogicalPlan(AstNode astNode) throws QueryProcessException, MetadataException {
        this.analyze(astNode);
        return this.initializedOperator;
    }

    private void analyze(AstNode astNode) throws QueryProcessException, MetadataException {
        Token token = astNode.getToken();
        if (token == null) {
            throw new IllegalASTFormatException("given token is null");
        }
        int tokenIntType = token.getType();
        switch (tokenIntType) {
            case 161: {
                this.analyzeInsert(astNode);
                return;
            }
            case 188: {
                this.analyzeSelectedPath(astNode);
                return;
            }
            case 151: {
                this.analyzeFrom(astNode);
                return;
            }
            case 209: {
                this.analyzeWhere(astNode);
                return;
            }
            case 155: {
                this.analyzeGroupBy(astNode);
                return;
            }
            case 150: {
                this.analyzeFill(astNode);
                return;
            }
            case 135: {
                this.analyzeAuthorAlter(astNode);
                return;
            }
            case 206: {
                this.analyzeUpdate(astNode);
                return;
            }
            case 144: {
                switch (astNode.getChild(0).getType()) {
                    case 200: {
                        this.analyzeMetadataDelete(astNode);
                        break;
                    }
                    case 164: {
                        this.analyzePropertyDeleteLabel(astNode);
                        break;
                    }
                    case 195: {
                        this.analyzeMetaDataDeleteFileLevel(astNode);
                        break;
                    }
                    default: {
                        this.analyzeDelete(astNode);
                    }
                }
                return;
            }
            case 190: {
                this.analyzeMetadataSetFileLevel(astNode);
                return;
            }
            case 132: {
                this.analyzePropertyAddLabel(astNode);
                return;
            }
            case 167: {
                this.analyzePropertyLink(astNode);
                return;
            }
            case 204: {
                this.analyzePropertyUnLink(astNode);
                return;
            }
            case 140: {
                switch (astNode.getChild(0).getType()) {
                    case 186: 
                    case 207: {
                        this.analyzeAuthorCreate(astNode);
                        break;
                    }
                    case 178: {
                        this.analyzeMetadataCreate(astNode);
                        break;
                    }
                    case 181: {
                        this.analyzePropertyCreate(astNode);
                        break;
                    }
                }
                return;
            }
            case 146: {
                switch (astNode.getChild(0).getType()) {
                    case 186: 
                    case 207: {
                        this.analyzeAuthorDrop(astNode);
                        break;
                    }
                }
                return;
            }
            case 153: {
                this.analyzeAuthorGrant(astNode);
                return;
            }
            case 154: {
                this.analyzeWatermarkEmbedding(astNode, 34);
                return;
            }
            case 185: {
                this.analyzeWatermarkEmbedding(astNode, 35);
                return;
            }
            case 184: {
                this.analyzeAuthorRevoke(astNode);
                return;
            }
            case 169: {
                this.analyzeDataLoad(astNode);
                return;
            }
            case 183: {
                this.initializedOperator = new QueryOperator(27);
                break;
            }
            case 168: {
                this.analyzeList(astNode);
                return;
            }
            case 165: {
                this.analyzeLimit(astNode);
                return;
            }
            case 193: {
                this.analyzeSlimit(astNode);
                return;
            }
            case 194: {
                this.analyzeSoffset(astNode);
                return;
            }
            case 202: {
                this.analyzeTTL(astNode);
                return;
            }
            case 156: {
                ((QueryOperator)this.initializedOperator).setGroupByDevice(true);
                return;
            }
            default: {
                throw new QueryProcessException("Not supported TqlParser type " + token.getText());
            }
        }
        for (Node node : astNode.getChildren()) {
            this.analyze((AstNode)node);
        }
    }

    private void analyzeTTL(AstNode astNode) throws QueryProcessException {
        int tokenType = astNode.getChild(0).getToken().getType();
        switch (tokenType) {
            case 190: {
                this.analyzeSetTTL(astNode);
                break;
            }
            case 205: {
                this.analyzeUnsetTTL(astNode);
                break;
            }
            case 191: {
                this.analyzeShowTTL(astNode);
                break;
            }
            default: {
                throw new QueryProcessException("Not supported TSParser type in TTL:" + tokenType);
            }
        }
    }

    private void analyzeSetTTL(AstNode astNode) {
        String path = this.parsePath(astNode.getChild(1)).getFullPath();
        long dataTTL = Long.parseLong(astNode.getChild(2).getText());
        SetTTLOperator operator = new SetTTLOperator(63);
        this.initializedOperator = operator;
        operator.setStorageGroup(path);
        operator.setDataTTL(dataTTL);
    }

    private void analyzeUnsetTTL(AstNode astNode) {
        String path = this.parsePath(astNode.getChild(1)).getFullPath();
        SetTTLOperator operator = new SetTTLOperator(64);
        this.initializedOperator = operator;
        operator.setStorageGroup(path);
    }

    private void analyzeShowTTL(AstNode astNode) {
        ArrayList<String> storageGroups = new ArrayList<String>();
        for (int i = 1; i < astNode.getChildCount(); ++i) {
            Path path = this.parsePath(astNode.getChild(i));
            storageGroups.add(path.getFullPath());
        }
        this.initializedOperator = new ShowTTLOperator(storageGroups);
    }

    private void analyzeSlimit(AstNode astNode) throws LogicalOperatorException {
        int seriesLimit;
        AstNode unit = astNode.getChild(0);
        try {
            seriesLimit = Integer.parseInt(unit.getText().trim());
        }
        catch (NumberFormatException e) {
            throw new LogicalOperatorException("SLIMIT <SN>: SN should be Int32.");
        }
        if (seriesLimit <= 0) {
            throw new LogicalOperatorException("SLIMIT <SN>: SN must be a positive integer and can not be zero.");
        }
        ((QueryOperator)this.initializedOperator).setSeriesLimit(seriesLimit);
    }

    private void analyzeSoffset(AstNode astNode) throws LogicalOperatorException {
        AstNode unit = astNode.getChild(0);
        try {
            ((QueryOperator)this.initializedOperator).setSeriesOffset(Integer.parseInt(unit.getText().trim()));
        }
        catch (NumberFormatException e) {
            throw new LogicalOperatorException("SOFFSET <SOFFSETValue>: SOFFSETValue should be Int32.");
        }
    }

    private void analyzeLimit(AstNode astNode) throws LogicalOperatorException {
        int rowsLimit;
        AstNode unit = astNode.getChild(0);
        try {
            rowsLimit = Integer.parseInt(unit.getText().trim());
        }
        catch (NumberFormatException e) {
            throw new LogicalOperatorException("LIMIT <N>: N should be Int32.");
        }
        if (rowsLimit <= 0) {
            throw new LogicalOperatorException("LIMIT <N>: N must be a positive integer and can not be zero.");
        }
    }

    private void analyzeList(AstNode astNode) {
        int childrenSize = astNode.getChildren().size();
        if (childrenSize == 1) {
            this.analyzeSimpleList(astNode);
        } else if (childrenSize == 3) {
            this.analyzeComplexList(astNode);
        }
    }

    private void analyzeSimpleList(AstNode astNode) {
        int tokenType = astNode.getChild(0).getType();
        if (tokenType == 207) {
            this.initializedOperator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER);
        } else if (tokenType == 186) {
            this.initializedOperator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE);
        }
    }

    private void analyzeComplexList(AstNode astNode) {
        int tokenType = astNode.getChild(1).getType();
        if (tokenType == 207) {
            AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
            this.initializedOperator = operator;
            operator.setUserName(astNode.getChild(1).getChild(0).getText());
            operator.setNodeNameList(this.parsePath(astNode.getChild(2)));
        } else if (tokenType == 186) {
            AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
            this.initializedOperator = operator;
            operator.setRoleName(astNode.getChild(1).getChild(0).getText());
            operator.setNodeNameList(this.parsePath(astNode.getChild(2)));
        } else if (tokenType == 134) {
            tokenType = astNode.getChild(0).getType();
            if (tokenType == 180) {
                tokenType = astNode.getChild(2).getType();
                if (tokenType == 207) {
                    AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
                    this.initializedOperator = operator;
                    operator.setUserName(astNode.getChild(2).getChild(0).getText());
                } else if (tokenType == 186) {
                    AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
                    this.initializedOperator = operator;
                    operator.setRoleName(astNode.getChild(2).getChild(0).getText());
                }
            } else {
                tokenType = astNode.getChild(2).getType();
                if (tokenType == 207) {
                    AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_ROLES);
                    this.initializedOperator = operator;
                    operator.setUserName(astNode.getChild(2).getChild(0).getText());
                } else if (tokenType == 186) {
                    AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_USERS);
                    this.initializedOperator = operator;
                    operator.setRoleName(astNode.getChild(2).getChild(0).getText());
                }
            }
        }
    }

    private void analyzePropertyCreate(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(54, PropertyOperator.PropertyType.ADD_TREE);
        propertyOperator.setPropertyPath(new Path(astNode.getChild(0).getChild(0).getText()));
        this.initializedOperator = propertyOperator;
    }

    private void analyzePropertyAddLabel(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(55, PropertyOperator.PropertyType.ADD_PROPERTY_LABEL);
        Path propertyLabel = this.parsePropertyAndLabel(astNode, 0);
        propertyOperator.setPropertyPath(propertyLabel);
        this.initializedOperator = propertyOperator;
    }

    private void analyzePropertyDeleteLabel(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(56, PropertyOperator.PropertyType.DELETE_PROPERTY_LABEL);
        Path propertyLabel = this.parsePropertyAndLabel(astNode, 0);
        propertyOperator.setPropertyPath(propertyLabel);
        this.initializedOperator = propertyOperator;
    }

    private Path parsePropertyAndLabel(AstNode astNode, int startIndex) {
        String label = astNode.getChild(startIndex).getChild(0).getText();
        String property = astNode.getChild(startIndex + 1).getChild(0).getText();
        return new Path(new String[]{property, label});
    }

    private void analyzePropertyLink(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(57, PropertyOperator.PropertyType.ADD_PROPERTY_TO_METADATA);
        Path metaPath = this.parsePath(astNode.getChild(0));
        propertyOperator.setMetadataPath(metaPath);
        Path propertyLabel = this.parsePropertyAndLabel(astNode, 1);
        propertyOperator.setPropertyPath(propertyLabel);
        this.initializedOperator = propertyOperator;
    }

    private void analyzePropertyUnLink(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(58, PropertyOperator.PropertyType.DEL_PROPERTY_FROM_METADATA);
        Path metaPath = this.parsePath(astNode.getChild(0));
        propertyOperator.setMetadataPath(metaPath);
        Path propertyLabel = this.parsePropertyAndLabel(astNode, 1);
        propertyOperator.setPropertyPath(propertyLabel);
        this.initializedOperator = propertyOperator;
    }

    private void analyzeMetadataCreate(AstNode astNode) throws MetadataException {
        String compressor;
        Path series = this.parsePath(astNode.getChild(0));
        AstNode paramNode = astNode.getChild(1);
        String dataType = paramNode.getChild(0).getChild(0).getText().toUpperCase();
        String encodingType = paramNode.getChild(1).getChild(0).getText().toUpperCase();
        int offset = 2;
        if (paramNode.getChildren().size() > offset && paramNode.getChild(offset).getToken().getText().equals("TOK_COMPRESSOR")) {
            compressor = this.cascadeChildrenText(paramNode.getChild(offset).getChild(0)).toUpperCase();
            ++offset;
        } else {
            compressor = TSFileDescriptor.getInstance().getConfig().getCompressor().toUpperCase();
        }
        this.checkMetadataArgs(dataType, encodingType, compressor);
        HashMap<String, String> props = new HashMap<String, String>(paramNode.getChildCount() - offset + 1, 1.0f);
        while (offset < paramNode.getChildCount()) {
            AstNode node = paramNode.getChild(offset++);
            props.put(node.getChild(0).getText().toLowerCase(), this.cascadeChildrenText(node.getChild(1)));
        }
        CreateTimeSeriesOperator createTimeSeriesOperator = new CreateTimeSeriesOperator(51);
        createTimeSeriesOperator.setPath(series);
        createTimeSeriesOperator.setDataType(TSDataType.valueOf((String)dataType));
        createTimeSeriesOperator.setEncoding(TSEncoding.valueOf((String)encodingType));
        createTimeSeriesOperator.setProps(props);
        createTimeSeriesOperator.setCompressor(CompressionType.valueOf((String)compressor));
        this.initializedOperator = createTimeSeriesOperator;
    }

    private void analyzeMetadataDelete(AstNode astNode) {
        ArrayList<Path> deletePaths = new ArrayList<Path>();
        for (int i = 0; i < astNode.getChild(0).getChildCount(); ++i) {
            deletePaths.add(this.parsePath(astNode.getChild(0).getChild(i)));
        }
        DeleteTimeSeriesOperator deleteTimeSeriesOperator = new DeleteTimeSeriesOperator(52);
        deleteTimeSeriesOperator.setDeletePathList(deletePaths);
        this.initializedOperator = deleteTimeSeriesOperator;
    }

    private void analyzeMetadataSetFileLevel(AstNode astNode) {
        SetStorageGroupOperator setStorageGroupOperator = new SetStorageGroupOperator(53);
        Path path = this.parsePath(astNode.getChild(0).getChild(0));
        setStorageGroupOperator.setPath(path);
        this.initializedOperator = setStorageGroupOperator;
    }

    private void analyzeMetaDataDeleteFileLevel(AstNode astNode) {
        ArrayList<Path> deletePaths = new ArrayList<Path>();
        for (int i = 0; i < astNode.getChild(0).getChildCount(); ++i) {
            deletePaths.add(this.parsePath(astNode.getChild(0).getChild(i)));
        }
        DeleteStorageGroupOperator deleteStorageGroupOperator = new DeleteStorageGroupOperator(62);
        deleteStorageGroupOperator.setDeletePathList(deletePaths);
        this.initializedOperator = deleteStorageGroupOperator;
    }

    private void analyzeInsert(AstNode astNode) throws QueryProcessException {
        long timestamp;
        InsertOperator insertOp = new InsertOperator(24);
        this.initializedOperator = insertOp;
        this.analyzeSelectedPath(astNode.getChild(0));
        try {
            AstNode timeValue = astNode.getChild(2).getChild(0);
            timestamp = timeValue.getType() == 142 ? this.parseTimeFormat(this.cascadeChildrenText(timeValue)) : Long.parseLong(astNode.getChild(2).getChild(0).getText());
        }
        catch (NumberFormatException e) {
            throw new LogicalOperatorException("Need a long value in insert clause, but given:" + astNode.getChild(2).getChild(0).getText());
        }
        if (astNode.getChild(1).getChildCount() != astNode.getChild(2).getChildCount()) {
            throw new QueryProcessException("number of measurement is NOT EQUAL TO the number of values");
        }
        insertOp.setTime(timestamp);
        String[] measurementList = new String[astNode.getChild(1).getChildCount() - 1];
        for (int i = 1; i < astNode.getChild(1).getChildCount(); ++i) {
            String measurement = astNode.getChild(1).getChild(i).getText();
            if (measurement.contains("\"") || measurement.contains("'")) {
                measurement = measurement.substring(1, measurement.length() - 1);
            }
            measurementList[i - 1] = measurement;
        }
        insertOp.setMeasurementList(measurementList);
        AstNode valueKey = astNode.getChild(2);
        String[] valueList = new String[valueKey.getChildCount() - 1];
        for (int i = 1; i < valueKey.getChildCount(); ++i) {
            AstNode node = valueKey.getChild(i);
            valueList[i - 1] = this.cascadeChildrenText(node);
        }
        insertOp.setValueList(valueList);
    }

    private void analyzeUpdate(AstNode astNode) throws LogicalOperatorException {
        if (astNode.getChildCount() > 3) {
            throw new LogicalOperatorException("UPDATE clause doesn't support multi-update yet.");
        }
        UpdateOperator updateOp = new UpdateOperator(26);
        this.initializedOperator = updateOp;
        FromOperator fromOp = new FromOperator(151);
        fromOp.addPrefixTablePath(this.parsePath(astNode.getChild(0)));
        updateOp.setFromOperator(fromOp);
        SelectOperator selectOp = new SelectOperator(188);
        selectOp.addSelectPath(this.parsePath(astNode.getChild(1).getChild(0)));
        updateOp.setSelectOperator(selectOp);
        updateOp.setValue(astNode.getChild(1).getChild(1).getText());
        this.analyzeWhere(astNode.getChild(2));
    }

    private void analyzeDelete(AstNode astNode) throws LogicalOperatorException {
        this.initializedOperator = new DeleteDataOperator(25);
        SelectOperator selectOp = new SelectOperator(188);
        int selChildCount = astNode.getChildCount() - 1;
        for (int i = 0; i < selChildCount; ++i) {
            AstNode child = astNode.getChild(i);
            if (child.getType() != 178) {
                throw new LogicalOperatorException("children FROM clause except last one must all be seriesPath like root.a.b, actual:" + child.getText());
            }
            Path tablePath = this.parsePath(child);
            selectOp.addSelectPath(tablePath);
        }
        ((SFWOperator)this.initializedOperator).setSelectOperator(selectOp);
        this.analyzeWhere(astNode.getChild(selChildCount));
        long deleteTime = this.parseDeleteTimeFilter((DeleteDataOperator)this.initializedOperator);
        ((DeleteDataOperator)this.initializedOperator).setTime(deleteTime);
    }

    private long parseDeleteTimeFilter(DeleteDataOperator operator) throws LogicalOperatorException {
        FilterOperator filterOperator = operator.getFilterOperator();
        if (!filterOperator.isLeaf()) {
            throw new LogicalOperatorException("For delete command, where clause must be like : time < XXX or time <= XXX");
        }
        if (filterOperator.getTokenIntType() != 14 && filterOperator.getTokenIntType() != 13) {
            throw new LogicalOperatorException("For delete command, where clause must be like : time < XXX or time <= XXX");
        }
        long time = Long.parseLong(((BasicFunctionOperator)filterOperator).getValue());
        if (filterOperator.getTokenIntType() == 14) {
            --time;
        }
        return time;
    }

    private void analyzeFrom(AstNode node) throws LogicalOperatorException {
        int selChildCount = node.getChildCount();
        FromOperator from = new FromOperator(22);
        for (int i = 0; i < selChildCount; ++i) {
            AstNode child = node.getChild(i);
            if (child.getType() != 178) {
                throw new LogicalOperatorException("children FROM clause must all be seriesPath like root.a.b, actual:" + child.getText());
            }
            Path tablePath = this.parsePath(child);
            from.addPrefixTablePath(tablePath);
        }
        ((SFWOperator)this.initializedOperator).setFromOperator(from);
    }

    private void analyzeSelectedPath(AstNode astNode) throws LogicalOperatorException {
        int tokenIntType = astNode.getType();
        SelectOperator selectOp = new SelectOperator(188);
        if (tokenIntType == 188) {
            int selChildCount = astNode.getChildCount();
            for (int i = 0; i < selChildCount; ++i) {
                AstNode child = astNode.getChild(i);
                if (child.getChild(0).getType() == 133) {
                    AstNode cluster = child.getChild(0);
                    AstNode pathChild = cluster.getChild(0);
                    Path selectPath = this.parsePath(pathChild);
                    String aggregation = cluster.getChild(1).getText();
                    selectOp.addClusterPath(selectPath, aggregation);
                    continue;
                }
                Path selectPath = this.parsePath(child);
                selectOp.addSelectPath(selectPath);
            }
        } else if (tokenIntType == 178) {
            Path selectPath = this.parsePath(astNode);
            selectOp.addSelectPath(selectPath);
        } else {
            throw new LogicalOperatorException("Children SELECT clause must all be seriesPath like root.a.b, actual:" + astNode.dump());
        }
        ((SFWOperator)this.initializedOperator).setSelectOperator(selectOp);
    }

    private void analyzeWhere(AstNode astNode) throws LogicalOperatorException {
        if (astNode.getType() != 209) {
            throw new LogicalOperatorException("Given node is not WHERE! please check whether SQL statement is correct.");
        }
        if (astNode.getChildCount() != 1) {
            throw new LogicalOperatorException("Where clause has" + astNode.getChildCount() + " child, please check whether SQL grammar is correct.");
        }
        FilterOperator whereOp = new FilterOperator(23);
        AstNode child = astNode.getChild(0);
        this.analyzeWhere(child, child.getType(), whereOp);
        ((SFWOperator)this.initializedOperator).setFilterOperator(whereOp.getChildren().get(0));
    }

    private void analyzeWhere(AstNode ast, int tokenIntType, FilterOperator filterOp) throws LogicalOperatorException {
        int childCount = ast.getChildCount();
        switch (tokenIntType) {
            case 111: {
                if (childCount != 1) {
                    throw new LogicalOperatorException("Parsing where clause failed: NOT operator requires one param");
                }
                FilterOperator notOp = new FilterOperator(3);
                filterOp.addChildOperator(notOp);
                AstNode childAstNode = ast.getChild(0);
                int childNodeTokenType = childAstNode.getToken().getType();
                this.analyzeWhere(childAstNode, childNodeTokenType, notOp);
                break;
            }
            case 104: 
            case 112: {
                if (childCount != 2) {
                    throw new LogicalOperatorException("Parsing where clause failed! node has " + childCount + " parameter.");
                }
                FilterOperator binaryOp = new FilterOperator(TqlParserConstant.getTSTokenIntType(tokenIntType));
                filterOp.addChildOperator(binaryOp);
                for (int i = 0; i < childCount; ++i) {
                    AstNode childAstNode = ast.getChild(i);
                    int childNodeTokenType = childAstNode.getToken().getType();
                    this.analyzeWhere(childAstNode, childNodeTokenType, binaryOp);
                }
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                Pair<Path, String> pair = this.parseLeafNode(ast);
                BasicFunctionOperator basic = new BasicFunctionOperator(TqlParserConstant.getTSTokenIntType(tokenIntType), (Path)pair.left, (String)pair.right);
                filterOp.addChildOperator(basic);
                break;
            }
            default: {
                throw new LogicalOperatorException(String.valueOf(tokenIntType), "");
            }
        }
    }

    private void analyzeGroupBy(AstNode astNode) throws LogicalOperatorException {
        AstNode originNode;
        SelectOperator selectOp = ((QueryOperator)this.initializedOperator).getSelectOperator();
        if (selectOp.getSuffixPaths().size() != selectOp.getAggregations().size()) {
            throw new LogicalOperatorException("Group by must bind each seriesPath with an aggregation function");
        }
        ((QueryOperator)this.initializedOperator).setGroupBy(true);
        int childCount = astNode.getChildCount();
        long value = this.parseTokenTime(astNode.getChild(0));
        ((QueryOperator)this.initializedOperator).setUnit(value);
        AstNode intervalsNode = astNode.getChild(childCount - 1);
        int intervalCount = intervalsNode.getChildCount();
        ArrayList<Pair<Long, Long>> intervals = new ArrayList<Pair<Long, Long>>();
        for (int i = 0; i < intervalCount; ++i) {
            AstNode intervalNode = intervalsNode.getChild(i);
            AstNode startNode = intervalNode.getChild(0);
            long startTime = startNode.getType() == 142 ? this.parseTokenTime(startNode) : Long.parseLong(startNode.getText());
            AstNode endNode = intervalNode.getChild(1);
            long endTime = endNode.getType() == 142 ? this.parseTokenTime(endNode) : Long.parseLong(endNode.getText());
            intervals.add((Pair<Long, Long>)new Pair((Object)startTime, (Object)endTime));
        }
        ((QueryOperator)this.initializedOperator).setIntervals(intervals);
        long originTime = childCount == 3 ? ((originNode = astNode.getChild(1).getChild(0)).getType() == 142 ? this.parseTokenTime(originNode) : Long.parseLong(originNode.getText())) : this.parseTimeFormat("1970-1-01T00:00:00");
        ((QueryOperator)this.initializedOperator).setOrigin(originTime);
    }

    private void analyzeFill(AstNode node) throws LogicalOperatorException {
        FilterOperator filterOperator = ((SFWOperator)this.initializedOperator).getFilterOperator();
        if (!filterOperator.isLeaf() || filterOperator.getTokenIntType() != 11) {
            throw new LogicalOperatorException("Only \"=\" can be used in fill function");
        }
        EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
        int childNum = node.getChildCount();
        block4: for (int i = 0; i < childNum; ++i) {
            AstNode childNode = node.getChild(i);
            TSDataType dataType = this.parseTypeNode(childNode.getChild(0));
            AstNode fillTypeNode = childNode.getChild(1);
            switch (fillTypeNode.getType()) {
                case 166: {
                    this.checkTypeFill(dataType, 166);
                    if (fillTypeNode.getChildCount() == 2) {
                        long beforeRange = this.parseTimeUnit(fillTypeNode.getChild(0));
                        long afterRange = this.parseTimeUnit(fillTypeNode.getChild(1));
                        fillTypes.put(dataType, new LinearFill(beforeRange, afterRange));
                        continue block4;
                    }
                    if (fillTypeNode.getChildCount() == 0) {
                        fillTypes.put(dataType, new LinearFill(-1L, -1L));
                        continue block4;
                    }
                    throw new LogicalOperatorException("Linear fill type must have 0 or 2 valid time ranges");
                }
                case 179: {
                    this.checkTypeFill(dataType, 179);
                    if (fillTypeNode.getChildCount() == 1) {
                        long preRange = this.parseTimeUnit(fillTypeNode.getChild(0));
                        fillTypes.put(dataType, new PreviousFill(preRange));
                        continue block4;
                    }
                    if (fillTypeNode.getChildCount() == 0) {
                        fillTypes.put(dataType, new PreviousFill(-1L));
                        continue block4;
                    }
                    throw new LogicalOperatorException("Previous fill type must have 0 or 1 valid time range");
                }
            }
        }
        ((QueryOperator)this.initializedOperator).setFillTypes(fillTypes);
        ((QueryOperator)this.initializedOperator).setFill(true);
    }

    private void checkTypeFill(TSDataType dataType, int type) throws LogicalOperatorException {
        switch (dataType) {
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: {
                if (type != 166 && type != 179) {
                    throw new LogicalOperatorException(dataType.toString(), String.format("type %s cannot use %s fill function", dataType, TqlParser.tokenNames[type]));
                }
                return;
            }
            case BOOLEAN: 
            case TEXT: {
                if (type != 179) {
                    throw new LogicalOperatorException(dataType.toString(), String.format("type %s cannot use %s fill function", dataType, TqlParser.tokenNames[type]));
                }
                return;
            }
        }
    }

    private TSDataType parseTypeNode(AstNode typeNode) throws LogicalOperatorException {
        String type;
        switch (type = typeNode.getText().toLowerCase()) {
            case "int32": {
                return TSDataType.INT32;
            }
            case "int64": {
                return TSDataType.INT64;
            }
            case "float": {
                return TSDataType.FLOAT;
            }
            case "double": {
                return TSDataType.DOUBLE;
            }
            case "boolean": {
                return TSDataType.BOOLEAN;
            }
            case "text": {
                return TSDataType.TEXT;
            }
        }
        throw new LogicalOperatorException(type, "");
    }

    private long parseTimeUnit(AstNode node) throws LogicalOperatorException {
        long timeInterval = this.parseTokenDuration(node);
        if (timeInterval <= 0L) {
            throw new LogicalOperatorException("Interval must more than 0.");
        }
        return timeInterval;
    }

    private Pair<Path, String> parseLeafNode(AstNode node) throws LogicalOperatorException {
        String seriesValue;
        if (node.getChildCount() != 2) {
            throw new LogicalOperatorException();
        }
        AstNode col = node.getChild(0);
        if (col.getType() != 178) {
            throw new LogicalOperatorException();
        }
        Path seriesPath = this.parsePath(col);
        AstNode rightKey = node.getChild(1);
        if (rightKey.getChild(0).getType() == 142) {
            if (!seriesPath.equals("time")) {
                throw new LogicalOperatorException(seriesPath.toString(), "Date can only be used to time");
            }
            seriesValue = this.parseTokenTime(rightKey.getChild(0)) + "";
        } else {
            seriesValue = rightKey.getType() == 143 ? this.parseTokenDataExpression(rightKey.getChild(0)) + "" : this.cascadeChildrenText(rightKey);
        }
        return new Pair((Object)seriesPath, (Object)seriesValue);
    }

    private Long parseTokenDataExpression(AstNode astNode) throws LogicalOperatorException {
        if (astNode.getType() == 114) {
            return this.parseTokenDataExpression(astNode.getChild(0)) + this.parseTokenDataExpression(astNode.getChild(1));
        }
        if (astNode.getType() == 100) {
            return this.parseTokenDataExpression(astNode.getChild(0)) - this.parseTokenDataExpression(astNode.getChild(1));
        }
        return this.parseTokenTime(astNode);
    }

    private Long parseTokenTime(AstNode astNode) throws LogicalOperatorException {
        if (astNode.getType() == 147) {
            return this.parseTokenDuration(astNode);
        }
        return this.parseTimeFormat(this.cascadeChildrenText(astNode));
    }

    private Long parseTokenDuration(AstNode astNode) {
        String durationStr = this.cascadeChildrenText(astNode);
        String timestampPrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision();
        long total = 0L;
        long tmp = 0L;
        for (int i = 0; i < durationStr.length(); ++i) {
            char ch = durationStr.charAt(i);
            if (Character.isDigit(ch)) {
                tmp *= 10L;
                tmp += (long)(ch - 48);
                continue;
            }
            String unit = durationStr.charAt(i) + "";
            if (i + 1 < durationStr.length() && !Character.isDigit(durationStr.charAt(i + 1))) {
                unit = unit + durationStr.charAt(++i);
            }
            total += DatetimeUtils.convertDurationStrToLong(tmp, unit.toLowerCase(), timestampPrecision);
            tmp = 0L;
        }
        return total;
    }

    private String cascadeChildrenText(AstNode astNode) {
        StringContainer sc = new StringContainer();
        for (Node n : astNode.getChildren()) {
            sc.addTail(new String[]{((AstNode)n).getText()});
        }
        return sc.toString();
    }

    long parseTimeFormat(String timestampStr) throws LogicalOperatorException {
        if (timestampStr == null || timestampStr.trim().equals("")) {
            throw new LogicalOperatorException("Input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now")) {
            return System.currentTimeMillis();
        }
        try {
            return DatetimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new LogicalOperatorException(timestampStr, "Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.");
        }
    }

    private Path parsePath(AstNode node) {
        String[] path;
        int childCount = node.getChildCount();
        if (childCount == 1 && node.getChild(0).getType() == 187) {
            AstNode childNode = node.getChild(0);
            childCount = childNode.getChildCount();
            path = new String[childCount + 1];
            path[0] = "root";
            for (int i = 0; i < childCount; ++i) {
                path[i + 1] = childNode.getChild(i).getText();
            }
        } else {
            path = new String[childCount];
            for (int i = 0; i < childCount; ++i) {
                path[i] = node.getChild(i).getText();
            }
        }
        return new Path(new StringContainer(path, "."));
    }

    private String removeStringQuote(String src) throws IllegalASTFormatException {
        if (src.length() < 3 || src.charAt(0) != '\'' || src.charAt(src.length() - 1) != '\'') {
            throw new IllegalASTFormatException("remove string", "error format for string with quote: ", src);
        }
        return src.substring(1, src.length() - 1);
    }

    private void analyzeDataLoad(AstNode astNode) throws IllegalASTFormatException {
        int childCount = astNode.getChildCount();
        if (childCount < 3 || !"root".equals(astNode.getChild(1).getText())) {
            throw new IllegalASTFormatException(DATA_LOAD_COMMAND, "Child count < 3\n", astNode.dump());
        }
        String csvPath = astNode.getChild(0).getText();
        if (csvPath.length() < 3 || csvPath.charAt(0) != '\'' || csvPath.charAt(csvPath.length() - 1) != '\'') {
            throw new IllegalASTFormatException(DATA_LOAD_COMMAND, "Error format csvPath: ", csvPath);
        }
        StringContainer sc = new StringContainer(".");
        sc.addTail(new String[]{"root"});
        for (int i = 2; i < childCount; ++i) {
            String pathNode = astNode.getChild(i).getText();
            sc.addTail(new String[]{pathNode});
        }
        this.initializedOperator = new LoadDataOperator(45, csvPath.substring(1, csvPath.length() - 1), sc.toString());
    }

    private void analyzeAuthorCreate(AstNode astNode) throws IllegalASTFormatException {
        AuthorOperator authorOperator;
        int childCount = astNode.getChildCount();
        if (childCount == 2) {
            authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_USER);
            authorOperator.setUserName(astNode.getChild(0).getChild(0).getText());
            authorOperator.setPassWord(this.removeStringQuote(astNode.getChild(1).getChild(0).getText()));
        } else if (childCount == 1) {
            authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_ROLE);
            authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
        } else {
            throw new IllegalASTFormatException(INCORRECT_AUTHOR_COMMAND);
        }
        this.initializedOperator = authorOperator;
    }

    private void analyzeAuthorAlter(AstNode astNode) throws IllegalASTFormatException {
        AstNode user;
        AuthorOperator authorOperator;
        int childCount = astNode.getChildCount();
        if (childCount == 1) {
            authorOperator = new AuthorOperator(46, AuthorOperator.AuthorType.UPDATE_USER);
            user = astNode.getChild(0);
            if (user.getChildCount() != 2) {
                throw new IllegalASTFormatException(UPDATE_PASSWORD_COMMAND);
            }
        } else {
            throw new IllegalASTFormatException(UPDATE_PASSWORD_COMMAND);
        }
        authorOperator.setUserName(user.getChild(0).getText());
        authorOperator.setNewPassword(this.removeStringQuote(user.getChild(1).getText()));
        this.initializedOperator = authorOperator;
    }

    private void analyzeAuthorDrop(AstNode astNode) throws IllegalASTFormatException {
        AuthorOperator authorOperator;
        block5: {
            block4: {
                int childCount = astNode.getChildCount();
                if (childCount != 1) break block4;
                switch (astNode.getChild(0).getType()) {
                    case 207: {
                        authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_USER);
                        authorOperator.setUserName(astNode.getChild(0).getChild(0).getText());
                        break block5;
                    }
                    case 186: {
                        authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_ROLE);
                        authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
                        break block5;
                    }
                    default: {
                        throw new IllegalASTFormatException(INCORRECT_AUTHOR_COMMAND);
                    }
                }
            }
            throw new IllegalASTFormatException(INCORRECT_AUTHOR_COMMAND);
        }
        this.initializedOperator = authorOperator;
    }

    private void analyzeWatermarkEmbedding(AstNode astNode, int tokenIntType) {
        int childCount = astNode.getChildCount();
        ArrayList<String> users = new ArrayList<String>();
        for (int i = 0; i < childCount; ++i) {
            String user = astNode.getChild(i).getText();
            users.add(user);
        }
        this.initializedOperator = new DataAuthOperator(tokenIntType, users);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeAuthorGrant(AstNode astNode) throws IllegalASTFormatException {
        AuthorOperator authorOperator;
        int childCount = astNode.getChildCount();
        if (childCount == 2) {
            authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE_TO_USER);
            authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
            authorOperator.setUserName(astNode.getChild(1).getChild(0).getText());
        } else {
            if (childCount != 3) throw new IllegalASTFormatException(INCORRECT_AUTHOR_COMMAND);
            AstNode privilegesNode = astNode.getChild(1);
            String[] privileges = new String[privilegesNode.getChildCount()];
            for (int i = 0; i < privileges.length; ++i) {
                privileges[i] = this.removeStringQuote(privilegesNode.getChild(i).getText());
            }
            Path nodePath = this.parsePath(astNode.getChild(2));
            if (astNode.getChild(0).getType() == 207) {
                authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_USER);
                authorOperator.setUserName(astNode.getChild(0).getChild(0).getText());
                authorOperator.setPrivilegeList(privileges);
                authorOperator.setNodeNameList(nodePath);
            } else {
                if (astNode.getChild(0).getType() != 186) throw new IllegalASTFormatException(INCORRECT_AUTHOR_COMMAND);
                authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE);
                authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
                authorOperator.setPrivilegeList(privileges);
                authorOperator.setNodeNameList(nodePath);
            }
        }
        this.initializedOperator = authorOperator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeAuthorRevoke(AstNode astNode) throws IllegalASTFormatException {
        AuthorOperator authorOperator;
        int childCount = astNode.getChildCount();
        if (childCount == 2) {
            authorOperator = new AuthorOperator(44, AuthorOperator.AuthorType.REVOKE_ROLE_FROM_USER);
            authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
            authorOperator.setUserName(astNode.getChild(1).getChild(0).getText());
        } else {
            if (childCount != 3) throw new IllegalASTFormatException(INCORRECT_AUTHOR_COMMAND);
            AstNode privilegesNode = astNode.getChild(1);
            String[] privileges = new String[privilegesNode.getChildCount()];
            for (int i = 0; i < privileges.length; ++i) {
                privileges[i] = this.removeStringQuote(privilegesNode.getChild(i).getText());
            }
            Path nodePath = this.parsePath(astNode.getChild(2));
            if (astNode.getChild(0).getType() == 207) {
                authorOperator = new AuthorOperator(44, AuthorOperator.AuthorType.REVOKE_USER);
                authorOperator.setUserName(astNode.getChild(0).getChild(0).getText());
                authorOperator.setPrivilegeList(privileges);
                authorOperator.setNodeNameList(nodePath);
            } else {
                if (astNode.getChild(0).getType() != 186) throw new IllegalASTFormatException(INCORRECT_AUTHOR_COMMAND);
                authorOperator = new AuthorOperator(44, AuthorOperator.AuthorType.REVOKE_ROLE);
                authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
                authorOperator.setPrivilegeList(privileges);
                authorOperator.setNodeNameList(nodePath);
            }
        }
        this.initializedOperator = authorOperator;
    }

    private void checkMetadataArgs(String dataType, String encoding, String compressor) throws MetadataException {
        TSEncoding tsEncoding;
        TSDataType tsDataType;
        if (dataType == null) {
            throw new MetadataException("data type cannot be null");
        }
        try {
            tsDataType = TSDataType.valueOf((String)dataType);
        }
        catch (Exception e) {
            throw new MetadataException(String.format("data type %s not support", dataType));
        }
        if (encoding == null) {
            throw new MetadataException("encoding type cannot be null");
        }
        try {
            tsEncoding = TSEncoding.valueOf((String)encoding);
        }
        catch (Exception e) {
            throw new MetadataException(String.format("encoding %s is not support", encoding));
        }
        try {
            CompressionType.valueOf((String)compressor);
        }
        catch (Exception e) {
            throw new MetadataException(String.format("compressor %s is not support", compressor));
        }
        this.checkDataTypeEncoding(tsDataType, tsEncoding);
    }

    private void checkDataTypeEncoding(TSDataType tsDataType, TSEncoding tsEncoding) throws MetadataException {
        boolean throwExp = false;
        switch (tsDataType) {
            case BOOLEAN: {
                if (tsEncoding.equals((Object)TSEncoding.RLE) || tsEncoding.equals((Object)TSEncoding.PLAIN)) break;
                throwExp = true;
                break;
            }
            case INT32: 
            case INT64: {
                if (tsEncoding.equals((Object)TSEncoding.RLE) || tsEncoding.equals((Object)TSEncoding.PLAIN) || tsEncoding.equals((Object)TSEncoding.TS_2DIFF)) break;
                throwExp = true;
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                if (tsEncoding.equals((Object)TSEncoding.RLE) || tsEncoding.equals((Object)TSEncoding.PLAIN) || tsEncoding.equals((Object)TSEncoding.TS_2DIFF) || tsEncoding.equals((Object)TSEncoding.GORILLA)) break;
                throwExp = true;
                break;
            }
            case TEXT: {
                if (tsEncoding.equals((Object)TSEncoding.PLAIN)) break;
                throwExp = true;
                break;
            }
            default: {
                throwExp = true;
            }
        }
        if (throwExp) {
            throw new MetadataException(String.format("encoding %s does not support %s", tsEncoding, tsDataType));
        }
    }
}

