/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class UpdatePlan
extends PhysicalPlan {
    private List<Pair<Long, Long>> intervals = new ArrayList<Pair<Long, Long>>();
    private String value;
    private Path path;

    public UpdatePlan() {
        super(false, Operator.OperatorType.UPDATE);
    }

    public UpdatePlan(long startTime, long endTime, String value, Path path) {
        super(false, Operator.OperatorType.UPDATE);
        this.setValue(value);
        this.setPath(path);
        this.addInterval((Pair<Long, Long>)new Pair((Object)startTime, (Object)endTime));
    }

    public UpdatePlan(List<Pair<Long, Long>> list, String value, Path path) {
        super(false, Operator.OperatorType.UPDATE);
        this.setValue(value);
        this.setPath(path);
        this.intervals = list;
    }

    public List<Pair<Long, Long>> getIntervals() {
        return this.intervals;
    }

    public void addInterval(Pair<Long, Long> interval) {
        this.intervals.add(interval);
    }

    public void addIntervals(List<Pair<Long, Long>> intervals) {
        this.intervals.addAll(intervals);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    @Override
    public List<Path> getPaths() {
        ArrayList<Path> ret = new ArrayList<Path>();
        if (this.path != null) {
            ret.add(this.path);
        }
        return ret;
    }

    @Override
    public String printQueryPlan() {
        StringContainer sc = new StringContainer();
        String preSpace = "  ";
        sc.addTail(new String[]{"UpdatePlan:"});
        sc.addTail(new String[]{preSpace, "paths:  ", this.path.toString(), "\n"});
        sc.addTail(new String[]{preSpace, "value:", this.value, "\n"});
        sc.addTail(new String[]{preSpace, "filter: ", "\n"});
        this.intervals.forEach(p -> sc.addTail(new Object[]{preSpace, preSpace, p.left, p.right, "\n"}));
        return sc.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdatePlan that = (UpdatePlan)o;
        return Objects.equals(this.intervals, that.intervals) && Objects.equals(this.value, that.value) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.path);
    }
}

