/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;

public class QueryPlan
extends PhysicalPlan {
    private List<Path> paths = null;
    private List<TSDataType> dataTypes = null;
    private IExpression expression = null;
    private boolean isGroupByDevice = false;
    private List<String> measurementColumnList;
    private Map<String, Set<String>> measurementColumnsGroupByDevice;
    private Map<String, TSDataType> dataTypeConsistencyChecker;

    public QueryPlan() {
        super(true);
        this.setOperatorType(Operator.OperatorType.QUERY);
    }

    public QueryPlan(boolean isQuery, Operator.OperatorType operatorType) {
        super(isQuery, operatorType);
    }

    public void checkPaths(IQueryProcessExecutor executor) throws QueryProcessException {
        for (Path path : this.paths) {
            if (executor.judgePathExists(path)) continue;
            throw new QueryProcessException("Path doesn't exist: " + path);
        }
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public void setExpression(IExpression expression) {
        this.expression = expression;
    }

    @Override
    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }

    public boolean isGroupByDevice() {
        return this.isGroupByDevice;
    }

    public void setGroupByDevice(boolean groupByDevice) {
        this.isGroupByDevice = groupByDevice;
    }

    public void setMeasurementColumnList(List<String> measurementColumnList) {
        this.measurementColumnList = measurementColumnList;
    }

    public List<String> getMeasurementColumnList() {
        return this.measurementColumnList;
    }

    public void setMeasurementColumnsGroupByDevice(Map<String, Set<String>> measurementColumnsGroupByDevice) {
        this.measurementColumnsGroupByDevice = measurementColumnsGroupByDevice;
    }

    public Map<String, Set<String>> getMeasurementColumnsGroupByDevice() {
        return this.measurementColumnsGroupByDevice;
    }

    public void setDataTypeConsistencyChecker(Map<String, TSDataType> dataTypeConsistencyChecker) {
        this.dataTypeConsistencyChecker = dataTypeConsistencyChecker;
    }

    public Map<String, TSDataType> getDataTypeConsistencyChecker() {
        return this.dataTypeConsistencyChecker;
    }
}

