/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class BatchInsertPlan
extends PhysicalPlan {
    private String deviceId;
    private String[] measurements;
    private TSDataType[] dataTypes;
    private long[] times;
    private ByteBuffer timeBuffer;
    private Object[] columns;
    private ByteBuffer valueBuffer;
    private Set<Integer> index;
    private int rowCount = 0;
    private Long maxTime = null;
    private Long minTime = null;
    private List<Path> paths;

    public BatchInsertPlan() {
        super(false, Operator.OperatorType.BATCHINSERT);
    }

    public BatchInsertPlan(String deviceId, List<String> measurements) {
        super(false, Operator.OperatorType.BATCHINSERT);
        this.deviceId = deviceId;
        this.setMeasurements(measurements);
    }

    public BatchInsertPlan(String deviceId, String[] measurements, List<Integer> dataTypes) {
        super(false, Operator.OperatorType.BATCHINSERT);
        this.deviceId = deviceId;
        this.measurements = measurements;
        this.setDataTypes(dataTypes);
    }

    public Set<Integer> getIndex() {
        return this.index;
    }

    public void setIndex(Set<Integer> index) {
        this.index = index;
    }

    @Override
    public List<Path> getPaths() {
        if (this.paths != null) {
            return this.paths;
        }
        ArrayList<Path> ret = new ArrayList<Path>();
        for (String m : this.measurements) {
            ret.add(new Path(this.deviceId, m));
        }
        this.paths = ret;
        return ret;
    }

    @Override
    public void serializeTo(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.BATCHINSERT.ordinal();
        buffer.put((byte)type);
        this.putString(buffer, this.deviceId);
        buffer.putInt(this.measurements.length);
        for (String string : this.measurements) {
            this.putString(buffer, string);
        }
        for (String string : this.dataTypes) {
            buffer.putShort(string.serialize());
        }
        buffer.putInt(this.index.size());
        if (this.timeBuffer == null) {
            Iterator<Integer> iterator = this.index.iterator();
            while (iterator.hasNext()) {
                int loc = (Integer)iterator.next();
                buffer.putLong(this.times[loc]);
            }
        } else {
            buffer.put(this.timeBuffer.array());
            this.timeBuffer = null;
        }
        if (this.valueBuffer == null) {
            block11: for (int i = 0; i < this.measurements.length; ++i) {
                TSDataType dataType = this.dataTypes[i];
                switch (dataType) {
                    case INT32: {
                        int[] intValues = (int[])this.columns[i];
                        for (int loc : this.index) {
                            buffer.putInt(intValues[loc]);
                        }
                        continue block11;
                    }
                    case INT64: {
                        long[] lArray = (long[])this.columns[i];
                        for (int loc : this.index) {
                            buffer.putLong(lArray[loc]);
                        }
                        continue block11;
                    }
                    case FLOAT: {
                        float[] floatValues = (float[])this.columns[i];
                        for (int loc : this.index) {
                            buffer.putFloat(floatValues[loc]);
                        }
                        continue block11;
                    }
                    case DOUBLE: {
                        double[] doubleValues = (double[])this.columns[i];
                        for (int loc : this.index) {
                            buffer.putDouble(doubleValues[loc]);
                        }
                        continue block11;
                    }
                    case BOOLEAN: {
                        boolean[] boolValues = (boolean[])this.columns[i];
                        for (int loc : this.index) {
                            buffer.put(BytesUtils.boolToByte((boolean)boolValues[loc]));
                        }
                        continue block11;
                    }
                    case TEXT: {
                        Binary[] binaryValues = (Binary[])this.columns[i];
                        for (int loc : this.index) {
                            buffer.putInt(binaryValues[loc].getLength());
                            buffer.put(binaryValues[loc].getValues());
                        }
                        continue block11;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
                    }
                }
            }
        } else {
            buffer.put(this.valueBuffer.array());
            this.valueBuffer = null;
        }
    }

    public void setTimeBuffer(ByteBuffer timeBuffer) {
        this.timeBuffer = timeBuffer;
        this.timeBuffer.position(0);
    }

    public void setValueBuffer(ByteBuffer valueBuffer) {
        this.valueBuffer = valueBuffer;
        this.timeBuffer.position(0);
    }

    @Override
    public void deserializeFrom(ByteBuffer buffer) {
        int rows;
        int i;
        this.deviceId = this.readString(buffer);
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        for (i = 0; i < measurementSize; ++i) {
            this.measurements[i] = this.readString(buffer);
        }
        this.dataTypes = new TSDataType[measurementSize];
        for (i = 0; i < measurementSize; ++i) {
            this.dataTypes[i] = TSDataType.deserialize((short)buffer.getShort());
        }
        this.rowCount = rows = buffer.getInt();
        this.times = new long[rows];
        this.times = QueryDataSetUtils.readTimesFromBuffer(buffer, rows);
        this.columns = QueryDataSetUtils.readValuesFromBuffer(buffer, this.dataTypes, measurementSize, rows);
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(List<String> measurements) {
        this.measurements = new String[measurements.size()];
        measurements.toArray(this.measurements);
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(List<Integer> dataTypes) {
        this.dataTypes = new TSDataType[dataTypes.size()];
        for (int i = 0; i < dataTypes.size(); ++i) {
            this.dataTypes[i] = TSDataType.values()[dataTypes.get(i)];
        }
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public void setColumns(Object[] columns) {
        this.columns = columns;
    }

    public long getMinTime() {
        if (this.minTime != null) {
            return this.minTime;
        }
        this.minTime = Long.MAX_VALUE;
        long[] lArray = this.times;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long time = lArray[i];
            if (time >= this.minTime) continue;
            this.minTime = time;
        }
        return this.minTime;
    }

    public long getMaxTime() {
        if (this.maxTime != null) {
            return this.maxTime;
        }
        long maxTime = Long.MIN_VALUE;
        long[] lArray = this.times;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long time = lArray[i];
            if (time <= maxTime) continue;
            maxTime = time;
        }
        return maxTime;
    }

    public long[] getTimes() {
        return this.times;
    }

    public void setTimes(long[] times) {
        this.times = times;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int size) {
        this.rowCount = size;
    }
}

