/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.RootOperator;
import org.apache.iotdb.tsfile.read.common.Path;

public class PropertyOperator
extends RootOperator {
    private final PropertyType propertyType;
    private Path propertyPath;
    private Path metadataPath;

    public PropertyOperator(int tokenIntType, PropertyType type) {
        super(tokenIntType);
        this.propertyType = type;
        this.operatorType = Operator.OperatorType.PROPERTY;
    }

    public Path getPropertyPath() {
        return this.propertyPath;
    }

    public void setPropertyPath(Path propertyPath) {
        this.propertyPath = propertyPath;
    }

    public Path getMetadataPath() {
        return this.metadataPath;
    }

    public void setMetadataPath(Path metadataPath) {
        this.metadataPath = metadataPath;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public static enum PropertyType {
        ADD_TREE,
        ADD_PROPERTY_LABEL,
        DELETE_PROPERTY_LABEL,
        ADD_PROPERTY_TO_METADATA,
        DEL_PROPERTY_FROM_METADATA;


        public static PropertyType deserialize(short i) {
            switch (i) {
                case 0: {
                    return ADD_TREE;
                }
                case 1: {
                    return ADD_PROPERTY_LABEL;
                }
                case 2: {
                    return DELETE_PROPERTY_LABEL;
                }
                case 3: {
                    return ADD_PROPERTY_TO_METADATA;
                }
                case 4: {
                    return DEL_PROPERTY_FROM_METADATA;
                }
            }
            return null;
        }

        public short serialize() {
            switch (this) {
                case ADD_TREE: {
                    return 0;
                }
                case ADD_PROPERTY_LABEL: {
                    return 1;
                }
                case DELETE_PROPERTY_LABEL: {
                    return 2;
                }
                case ADD_PROPERTY_TO_METADATA: {
                    return 3;
                }
                case DEL_PROPERTY_FROM_METADATA: {
                    return 4;
                }
            }
            return -1;
        }
    }
}

