/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.exception.path.PTreePathException;
import org.apache.iotdb.db.exception.path.PathException;
import org.apache.iotdb.db.metadata.MTree;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.PNode;

public class PTree
implements Serializable {
    private static final long serialVersionUID = 2642766399323283900L;
    private static final String PTREE_NOT_EXIST = "PTree seriesPath not exist. ";
    private PNode root;
    private MTree mTree;
    private String name;
    private String space = "    ";

    PTree(String name, MTree mTree) {
        this.setRoot(new PNode(name, null, false));
        this.setName(name);
        this.setmTree(mTree);
    }

    int addPath(String path) throws PathException {
        int i;
        int addCount = 0;
        if (this.getRoot() == null) {
            throw new PTreePathException("Root Node is null, Please initialize root first");
        }
        String[] nodes = MetaUtils.getNodeNames(path, "\\.");
        if (nodes.length <= 1 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PTreePathException("Input seriesPath not exist. Path: " + path);
        }
        PNode cur = this.getRoot();
        for (i = 1; i < nodes.length - 1; ++i) {
            if (!cur.hasChild(nodes[i])) {
                cur.addChild(nodes[i], new PNode(nodes[i], cur, false));
                ++addCount;
            }
            cur = cur.getChild(nodes[i]);
        }
        if (cur.hasChild(nodes[i])) {
            throw new PTreePathException("Path already exists. Path: " + path);
        }
        PNode node = new PNode(nodes[i], cur, true);
        cur.addChild(node.getName(), node);
        return ++addCount;
    }

    void deletePath(String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, "\\.");
        if (nodes.length == 0 || !nodes[0].equals(this.getRoot().getName())) {
            throw new PTreePathException("Path not correct. Path:" + path);
        }
        PNode cur = this.getRoot();
        for (int i = 1; i < nodes.length; ++i) {
            if (!cur.hasChild(nodes[i])) {
                throw new PTreePathException("Path not correct. Node[" + cur.getName() + "] doesn't have child named:" + nodes[i]);
            }
            cur = cur.getChild(nodes[i]);
        }
        cur.getParent().deleteChild(cur.getName());
    }

    void linkMNode(String pTreePath, String mTreePath) throws PathException {
        List<String> paths = this.mTree.getAllPathInList(mTreePath);
        String[] nodes = MetaUtils.getNodeNames(pTreePath, "\\.");
        PNode leaf = this.getLeaf(this.getRoot(), nodes, 0);
        for (String p : paths) {
            leaf.linkMPath(p);
        }
    }

    void unlinkMNode(String pTreePath, String mTreePath) throws PathException {
        List<String> paths = this.mTree.getAllPathInList(mTreePath);
        String[] nodes = MetaUtils.getNodeNames(pTreePath, "\\.");
        PNode leaf = this.getLeaf(this.getRoot(), nodes, 0);
        for (String p : paths) {
            leaf.unlinkMPath(p);
        }
    }

    private PNode getLeaf(PNode node, String[] nodes, int idx) throws PathException {
        if (idx >= nodes.length) {
            throw new PTreePathException(PTREE_NOT_EXIST);
        }
        if (node.isLeaf()) {
            if (idx != nodes.length - 1 || !nodes[idx].equals(node.getName())) {
                throw new PTreePathException(PTREE_NOT_EXIST);
            }
            return node;
        }
        if (idx >= nodes.length - 1 || !node.hasChild(nodes[idx + 1])) {
            throw new PTreePathException(PTREE_NOT_EXIST);
        }
        return this.getLeaf(node.getChild(nodes[idx + 1]), nodes, idx + 1);
    }

    HashMap<String, List<String>> getAllLinkedPath(String path) throws PathException {
        String[] nodes = MetaUtils.getNodeNames(path, "\\.");
        PNode leaf = this.getLeaf(this.getRoot(), nodes, 0);
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        for (String MPath : leaf.getLinkedMTreePathMap().keySet()) {
            HashMap<String, List<String>> tr = this.getmTree().getAllPath(MPath);
            this.mergePathRes(res, tr);
        }
        return res;
    }

    private void mergePathRes(HashMap<String, List<String>> res, HashMap<String, List<String>> tr) {
        for (String key : tr.keySet()) {
            if (!res.containsKey(key)) {
                res.put(key, new ArrayList());
            }
            for (String p : tr.get(key)) {
                if (res.get(key).contains(p)) continue;
                res.get(key).add(p);
            }
        }
    }

    public String toString() {
        return this.pNodeToString(this.getRoot(), 0);
    }

    private String pNodeToString(PNode node, int tab) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < tab; ++i) {
            s.append(this.space);
        }
        s.append(node.getName());
        if (!node.isLeaf() && node.getChildren().size() > 0) {
            s.append(":{\n");
            boolean first = false;
            for (PNode child : node.getChildren().values()) {
                if (!first) {
                    first = true;
                } else {
                    s.append(",\n");
                }
                s.append(this.pNodeToString(child, tab + 1));
            }
            s.append("\n");
            for (int i = 0; i < tab; ++i) {
                s.append(this.space);
            }
            s.append("}");
        } else if (node.isLeaf()) {
            s.append(":{\n");
            String[] linkedPaths = (String[])node.getLinkedMTreePathMap().values().stream().map(Object::toString).toArray(String[]::new);
            for (int i = 0; i < linkedPaths.length; ++i) {
                if (i != linkedPaths.length - 1) {
                    s.append(this.getTabs(tab + 1)).append(linkedPaths[i]).append(",\n");
                    continue;
                }
                s.append(this.getTabs(tab + 1)).append(linkedPaths[i]).append("\n");
            }
            s.append(this.getTabs(tab)).append("}");
        }
        return s.toString();
    }

    private String getTabs(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(this.space);
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private MTree getmTree() {
        return this.mTree;
    }

    private void setmTree(MTree mTree) {
        this.mTree = mTree;
    }

    public PNode getRoot() {
        return this.root;
    }

    public void setRoot(PNode root) {
        this.root = root;
    }
}

