/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.upgrade;

import java.io.IOException;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.upgrade.UpgradeCheckStatus;
import org.apache.iotdb.db.engine.upgrade.UpgradeLog;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.tool.upgrade.UpgradeTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask
implements Runnable {
    private final TsFileResource upgradeResource;
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTask.class);
    private static final String COMMA_SEPERATOR = ",";

    public UpgradeTask(TsFileResource upgradeResource) {
        this.upgradeResource = upgradeResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.upgradeResource.getWriteQueryLock().readLock().lock();
            String tsfilePathBefore = this.upgradeResource.getFile().getAbsolutePath();
            String tsfilePathAfter = UpgradeUtils.getUpgradeFileName(this.upgradeResource.getFile());
            UpgradeLog.writeUpgradeLogFile(tsfilePathBefore + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.BEGIN_UPGRADE_FILE));
            try {
                UpgradeTool.upgradeOneTsfile((String)tsfilePathBefore, (String)tsfilePathAfter);
                UpgradeLog.writeUpgradeLogFile(tsfilePathBefore + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.AFTER_UPGRADE_FILE));
            }
            catch (IOException e) {
                logger.error("generate upgrade file failed, the file to be upgraded:{}", (Object)tsfilePathBefore, (Object)e);
                return;
            }
            finally {
                this.upgradeResource.getWriteQueryLock().readLock().unlock();
            }
            this.upgradeResource.getWriteQueryLock().writeLock().lock();
            try {
                FSFactoryProducer.getFSFactory().getFile(tsfilePathBefore).delete();
                FSFactoryProducer.getFSFactory().moveFile(FSFactoryProducer.getFSFactory().getFile(tsfilePathAfter), FSFactoryProducer.getFSFactory().getFile(tsfilePathBefore));
                UpgradeLog.writeUpgradeLogFile(tsfilePathBefore + COMMA_SEPERATOR + (Object)((Object)UpgradeCheckStatus.UPGRADE_SUCCESS));
                FSFactoryProducer.getFSFactory().getFile(tsfilePathAfter).getParentFile().delete();
            }
            finally {
                this.upgradeResource.getWriteQueryLock().writeLock().unlock();
            }
            UpgradeSevice.setCntUpgradeFileNum(UpgradeSevice.getCntUpgradeFileNum() - 1);
            logger.info("Upgrade completes, file path:{} , the remaining upgraded file num: {}", (Object)tsfilePathBefore, (Object)UpgradeSevice.getCntUpgradeFileNum());
        }
        catch (Exception e) {
            logger.error("meet error when upgrade file:{}", (Object)this.upgradeResource.getFile().getAbsolutePath(), (Object)e);
        }
    }
}

