/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.flush;

import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.iotdb.db.engine.flush.FlushManagerMBean;
import org.apache.iotdb.db.engine.flush.pool.FlushSubTaskPoolManager;
import org.apache.iotdb.db.engine.flush.pool.FlushTaskPoolManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushManager
implements FlushManagerMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(FlushManager.class);
    private ConcurrentLinkedDeque<TsFileProcessor> tsFileProcessorQueue = new ConcurrentLinkedDeque();
    private FlushTaskPoolManager flushPool = FlushTaskPoolManager.getInstance();

    @Override
    public void start() throws StartupException {
        FlushSubTaskPoolManager.getInstance().start();
        FlushTaskPoolManager.getInstance().start();
        try {
            JMXService.registerMBean(this, ServiceType.FLUSH_SERVICE.getJmxName());
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        FlushSubTaskPoolManager.getInstance().stop();
        FlushTaskPoolManager.getInstance().stop();
        JMXService.deregisterMBean(ServiceType.FLUSH_SERVICE.getJmxName());
    }

    @Override
    public ServiceType getID() {
        return ServiceType.FLUSH_SERVICE;
    }

    @Override
    public int getNumberOfWorkingTasks() {
        return this.flushPool.getWorkingTasksNumber();
    }

    @Override
    public int getNumberOfPendingTasks() {
        return this.flushPool.getWaitingTasksNumber();
    }

    @Override
    public int getNumberOfWorkingSubTasks() {
        return FlushSubTaskPoolManager.getInstance().getWorkingTasksNumber();
    }

    @Override
    public int getNumberOfPendingSubTasks() {
        return FlushSubTaskPoolManager.getInstance().getWaitingTasksNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTsFileProcessor(TsFileProcessor tsFileProcessor) {
        TsFileProcessor tsFileProcessor2 = tsFileProcessor;
        synchronized (tsFileProcessor2) {
            if (!tsFileProcessor.isManagedByFlushManager() && tsFileProcessor.getFlushingMemTableSize() > 0) {
                logger.info("storage group {} begin to submit a flush thread, flushing memtable size: {}", (Object)tsFileProcessor.getStorageGroupName(), (Object)tsFileProcessor.getFlushingMemTableSize());
                this.tsFileProcessorQueue.add(tsFileProcessor);
                tsFileProcessor.setManagedByFlushManager(true);
                this.flushPool.submit(new FlushThread());
            }
        }
    }

    private FlushManager() {
    }

    public static FlushManager getInstance() {
        return InstanceHolder.instance;
    }

    private static class InstanceHolder {
        private static FlushManager instance = new FlushManager();

        private InstanceHolder() {
        }
    }

    class FlushThread
    implements Runnable {
        FlushThread() {
        }

        @Override
        public void run() {
            TsFileProcessor tsFileProcessor = (TsFileProcessor)FlushManager.this.tsFileProcessorQueue.poll();
            tsFileProcessor.flushOneMemTable();
            tsFileProcessor.setManagedByFlushManager(false);
            FlushManager.this.registerTsFileProcessor(tsFileProcessor);
        }
    }
}

