/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import org.apache.iotdb.db.engine.cache.CacheHitRatioMonitorMXBean;
import org.apache.iotdb.db.engine.cache.DeviceMetaDataCache;
import org.apache.iotdb.db.engine.cache.TsFileMetaDataCache;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHitRatioMonitor
implements CacheHitRatioMonitorMXBean,
IService {
    double chunkMetaDataHitRatio;
    double tsfileMetaDataHitRatio;
    private static Logger logger = LoggerFactory.getLogger(CacheHitRatioMonitor.class);
    static final CacheHitRatioMonitor instance = AsyncCacheHitRatioHolder.access$000();

    @Override
    public void start() throws StartupException {
        try {
            JMXService.registerMBean(instance, ServiceType.CACHE_HIT_RATIO_DISPLAY_SERVICE.getJmxName());
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        JMXService.deregisterMBean(ServiceType.CACHE_HIT_RATIO_DISPLAY_SERVICE.getJmxName());
        logger.info("{}: stop {}...", (Object)"IoTDB", (Object)this.getID().getName());
    }

    @Override
    public ServiceType getID() {
        return ServiceType.CACHE_HIT_RATIO_DISPLAY_SERVICE;
    }

    @Override
    public double getChunkMetaDataHitRatio() {
        this.chunkMetaDataHitRatio = DeviceMetaDataCache.getInstance().calculateChunkMetaDataHitRatio();
        return this.chunkMetaDataHitRatio;
    }

    @Override
    public double getTsfileMetaDataHitRatio() {
        this.tsfileMetaDataHitRatio = TsFileMetaDataCache.getInstance().calculateTsfileMetaDataHitRatio();
        return this.tsfileMetaDataHitRatio;
    }

    public static CacheHitRatioMonitor getInstance() {
        return instance;
    }

    private static class AsyncCacheHitRatioHolder {
        private static final CacheHitRatioMonitor DISPLAYER = new CacheHitRatioMonitor();

        private AsyncCacheHitRatioHolder() {
        }

        static /* synthetic */ CacheHitRatioMonitor access$000() {
            return DISPLAYER;
        }
    }
}

