/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.adapter;

import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.conf.adapter.IoTDBConfigDynamicAdapter;
import org.apache.iotdb.db.conf.adapter.ManageDynamicParametersMBean;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageDynamicParameters
implements ManageDynamicParametersMBean,
IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageDynamicParameters.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());

    private ManageDynamicParameters() {
    }

    public static ManageDynamicParameters getInstance() {
        return ManageDynamicParametersHolder.INSTANCE;
    }

    @Override
    public void showDynamicParameters() {
        LOGGER.info("Memtable size threshold: {}B, Memtable number: {}, Tsfile size threshold: {}B, Compression ratio: {}, Storage group number: {}, Timeseries number: {}, Maximal timeseries number among storage groups: {}", new Object[]{CONFIG.getMemtableSizeThreshold(), CONFIG.getMaxMemtableNumber(), CONFIG.getTsFileSizeThreshold(), CompressionRatio.getInstance().getRatio(), IoTDBConfigDynamicAdapter.getInstance().getTotalStorageGroup(), IoTDBConfigDynamicAdapter.getInstance().getTotalTimeseries(), MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups()});
    }

    @Override
    public boolean isEnableDynamicAdapter() {
        return CONFIG.isEnableParameterAdapter();
    }

    @Override
    public void setEnableDynamicAdapter(boolean enableDynamicAdapter) {
        CONFIG.setEnableParameterAdapter(enableDynamicAdapter);
    }

    @Override
    public long getMemTableSizeThreshold() {
        return CONFIG.getMemtableSizeThreshold();
    }

    @Override
    public void setMemTableSizeThreshold(long memTableSizeThreshold) {
        CONFIG.setMemtableSizeThreshold(memTableSizeThreshold);
    }

    @Override
    public int getMemTableNumber() {
        return CONFIG.getMaxMemtableNumber();
    }

    @Override
    public void setMemTableNumber(int memTableNumber) {
        CONFIG.setMaxMemtableNumber(memTableNumber);
    }

    @Override
    public long getTsfileSizeThreshold() {
        return CONFIG.getTsFileSizeThreshold();
    }

    @Override
    public void setTsfileSizeThreshold(long tsfileSizeThreshold) {
        CONFIG.setTsFileSizeThreshold(tsfileSizeThreshold);
    }

    @Override
    public void start() throws StartupException {
        try {
            JMXService.registerMBean(ManageDynamicParameters.getInstance(), this.mbeanName);
            LOGGER.info("{}: start {}...", (Object)"IoTDB", (Object)this.getID().getName());
        }
        catch (Exception e) {
            LOGGER.error("Failed to start {} because: ", (Object)this.getID().getName(), (Object)e);
            throw new StartupException(e);
        }
    }

    @Override
    public void stop() {
        JMXService.deregisterMBean(this.mbeanName);
        LOGGER.info("{}: stop {}...", (Object)"IoTDB", (Object)this.getID().getName());
    }

    @Override
    public ServiceType getID() {
        return ServiceType.MANAGE_DYNAMIC_PARAMETERS_SERVICE;
    }

    private static class ManageDynamicParametersHolder {
        private static final ManageDynamicParameters INSTANCE = new ManageDynamicParameters();

        private ManageDynamicParametersHolder() {
        }
    }
}

