/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import java.util.List;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.LocalFileAuthorizer;
import org.apache.iotdb.db.auth.entity.PrivilegeType;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.tsfile.read.common.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityChecker {
    private static final String SUPER_USER = "root";
    private static final Logger logger = LoggerFactory.getLogger(AuthorityChecker.class);

    private AuthorityChecker() {
    }

    public static boolean check(String username, List<Path> paths, Operator.OperatorType type, String targetUser) throws AuthException {
        if (SUPER_USER.equals(username)) {
            return true;
        }
        int permission = AuthorityChecker.translateToPermissionId(type);
        if (permission == -1) {
            logger.error("OperateType not found. {}", (Object)type);
            return false;
        }
        if (permission == PrivilegeType.MODIFY_PASSWORD.ordinal() && username.equals(targetUser)) {
            return true;
        }
        if (!paths.isEmpty()) {
            for (Path path : paths) {
                if (AuthorityChecker.checkOnePath(username, path, permission)) continue;
                return false;
            }
        } else {
            return AuthorityChecker.checkOnePath(username, null, permission);
        }
        return true;
    }

    private static boolean checkOnePath(String username, Path path, int permission) throws AuthException {
        LocalFileAuthorizer authorizer = LocalFileAuthorizer.getInstance();
        try {
            String fullPath;
            String string = fullPath = path == null ? SUPER_USER : path.getFullPath();
            if (authorizer.checkUserPrivileges(username, fullPath, permission)) {
                return true;
            }
        }
        catch (AuthException e) {
            logger.error("Error occurs when checking the seriesPath {} for user {}", new Object[]{path, username, e});
        }
        return false;
    }

    private static int translateToPermissionId(Operator.OperatorType type) {
        switch (type) {
            case GRANT_ROLE_PRIVILEGE: {
                return PrivilegeType.GRANT_ROLE_PRIVILEGE.ordinal();
            }
            case CREATE_ROLE: {
                return PrivilegeType.CREATE_ROLE.ordinal();
            }
            case CREATE_USER: {
                return PrivilegeType.CREATE_USER.ordinal();
            }
            case MODIFY_PASSWORD: {
                return PrivilegeType.MODIFY_PASSWORD.ordinal();
            }
            case GRANT_USER_PRIVILEGE: {
                return PrivilegeType.GRANT_USER_PRIVILEGE.ordinal();
            }
            case REVOKE_ROLE_PRIVILEGE: {
                return PrivilegeType.REVOKE_ROLE_PRIVILEGE.ordinal();
            }
            case REVOKE_USER_PRIVILEGE: {
                return PrivilegeType.REVOKE_USER_PRIVILEGE.ordinal();
            }
            case GRANT_USER_ROLE: {
                return PrivilegeType.GRANT_USER_ROLE.ordinal();
            }
            case DELETE_USER: {
                return PrivilegeType.DELETE_USER.ordinal();
            }
            case DELETE_ROLE: {
                return PrivilegeType.DELETE_ROLE.ordinal();
            }
            case REVOKE_USER_ROLE: {
                return PrivilegeType.REVOKE_USER_ROLE.ordinal();
            }
            case SET_STORAGE_GROUP: {
                return PrivilegeType.SET_STORAGE_GROUP.ordinal();
            }
            case CREATE_TIMESERIES: {
                return PrivilegeType.CREATE_TIMESERIES.ordinal();
            }
            case DELETE_TIMESERIES: {
                return PrivilegeType.DELETE_TIMESERIES.ordinal();
            }
            case QUERY: 
            case SELECT: 
            case FILTER: 
            case GROUPBY: 
            case SEQTABLESCAN: 
            case TABLESCAN: 
            case INDEXQUERY: 
            case MERGEQUERY: 
            case AGGREGATION: {
                return PrivilegeType.READ_TIMESERIES.ordinal();
            }
            case DELETE: {
                return PrivilegeType.DELETE_TIMESERIES.ordinal();
            }
            case INSERT: 
            case LOADDATA: 
            case INDEX: {
                return PrivilegeType.INSERT_TIMESERIES.ordinal();
            }
            case UPDATE: {
                return PrivilegeType.UPDATE_TIMESERIES.ordinal();
            }
            case LIST_ROLE: 
            case LIST_ROLE_USERS: 
            case LIST_ROLE_PRIVILEGE: {
                return PrivilegeType.LIST_ROLE.ordinal();
            }
            case LIST_USER: 
            case LIST_USER_ROLES: 
            case LIST_USER_PRIVILEGE: {
                return PrivilegeType.LIST_USER.ordinal();
            }
            case AUTHOR: 
            case METADATA: 
            case BASIC_FUNC: 
            case FILEREAD: 
            case FROM: 
            case FUNC: 
            case HASHTABLESCAN: 
            case JOIN: 
            case LIMIT: 
            case MERGEJOIN: 
            case NULL: 
            case ORDERBY: 
            case PROPERTY: 
            case SFW: 
            case UNION: {
                logger.error("Illegal operator type authorization : {}", (Object)type);
                return -1;
            }
        }
        return -1;
    }
}

