/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with this work for additional information regarding copyright ownership.  The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License.  You may obtain a copy of the License at      http://www.apache.org/licenses/LICENSE-2.0  Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the specific language governing permissions and limitations under the License.
 */

package org.apache.iotdb.db.qp.physical.sys;

import java.util.List;
import org.apache.iotdb.db.qp.logical.Operator.OperatorType;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.read.common.Path;

public class ShowTTLPlan extends PhysicalPlan {

  private List<String> storageGroups;

  public ShowTTLPlan(List<String> storageGroups) {
    super(true);
    this.storageGroups = storageGroups;
    setOperatorType(OperatorType.TTL);
  }

  @Override
  public List<Path> getPaths() {
    return null;
  }

  public List<String> getStorageGroups() {
    return storageGroups;
  }
}