/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.writer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;

public class DefaultTsFileOutput
implements TsFileOutput {
    private FileOutputStream outputStream;

    public DefaultTsFileOutput(File file) throws FileNotFoundException {
        this.outputStream = new FileOutputStream(file);
    }

    public DefaultTsFileOutput(File file, boolean append) throws FileNotFoundException {
        this.outputStream = new FileOutputStream(file, append);
    }

    public DefaultTsFileOutput(FileOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(ByteBuffer b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPosition() throws IOException {
        return this.outputStream.getChannel().position();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public OutputStream wrapAsStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void truncate(long position) throws IOException {
        this.outputStream.getChannel().truncate(position);
    }
}

