/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class MeasurementSchema
implements Comparable<MeasurementSchema>,
Serializable {
    private TSDataType type;
    private TSEncoding encoding;
    private String measurementId;
    private TSEncodingBuilder encodingConverter;
    private CompressionType compressor;
    private Map<String, String> props = new HashMap<String, String>();

    public MeasurementSchema() {
    }

    public MeasurementSchema(String measurementId, TSDataType type, TSEncoding encoding) {
        this(measurementId, type, encoding, CompressionType.valueOf(TSFileConfig.compressor), Collections.emptyMap());
    }

    public MeasurementSchema(String measurementId, TSDataType type, TSEncoding encoding, CompressionType compressionType) {
        this(measurementId, type, encoding, compressionType, Collections.emptyMap());
    }

    public MeasurementSchema(String measurementId, TSDataType type, TSEncoding encoding, CompressionType compressionType, Map<String, String> props) {
        this.type = type;
        this.measurementId = measurementId;
        this.encoding = encoding;
        this.props = props == null ? Collections.emptyMap() : props;
        this.compressor = compressionType;
    }

    public static MeasurementSchema deserializeFrom(InputStream inputStream) throws IOException {
        MeasurementSchema measurementSchema = new MeasurementSchema();
        measurementSchema.measurementId = ReadWriteIOUtils.readString(inputStream);
        measurementSchema.type = ReadWriteIOUtils.readDataType(inputStream);
        measurementSchema.encoding = ReadWriteIOUtils.readEncoding(inputStream);
        measurementSchema.compressor = ReadWriteIOUtils.readCompressionType(inputStream);
        int size = ReadWriteIOUtils.readInt(inputStream);
        if (size > 0) {
            measurementSchema.props = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(inputStream);
                String value = ReadWriteIOUtils.readString(inputStream);
                measurementSchema.props.put(key, value);
            }
        }
        return measurementSchema;
    }

    public static MeasurementSchema deserializeFrom(ByteBuffer buffer) {
        MeasurementSchema measurementSchema = new MeasurementSchema();
        measurementSchema.measurementId = ReadWriteIOUtils.readString(buffer);
        measurementSchema.type = ReadWriteIOUtils.readDataType(buffer);
        measurementSchema.encoding = ReadWriteIOUtils.readEncoding(buffer);
        measurementSchema.compressor = ReadWriteIOUtils.readCompressionType(buffer);
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            measurementSchema.props = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                String value = ReadWriteIOUtils.readString(buffer);
                measurementSchema.props.put(key, value);
            }
        }
        return measurementSchema;
    }

    public String getMeasurementId() {
        return this.measurementId;
    }

    public void setMeasurementId(String measurementId) {
        this.measurementId = measurementId;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public TSEncoding getEncodingType() {
        return this.encoding;
    }

    public TSDataType getType() {
        return this.type;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public int getTypeLength() {
        switch (this.type) {
            case BOOLEAN: {
                return 1;
            }
            case INT32: {
                return 4;
            }
            case INT64: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case DOUBLE: {
                return 8;
            }
            case TEXT: {
                return TSFileConfig.maxStringLength * 4 + 4;
            }
        }
        throw new UnSupportedDataTypeException(this.type.toString());
    }

    public Encoder getTimeEncoder() {
        TSEncoding timeSeriesEncoder = TSEncoding.valueOf(TSFileConfig.timeEncoder);
        TSDataType timeType = TSDataType.valueOf(TSFileConfig.timeSeriesDataType);
        return TSEncodingBuilder.getConverter(timeSeriesEncoder).getEncoder(timeType);
    }

    public Encoder getValueEncoder() {
        if (this.encodingConverter == null) {
            this.encodingConverter = TSEncodingBuilder.getConverter(this.encoding);
            this.encodingConverter.initFromProps(this.props);
        }
        return this.encodingConverter.getEncoder(this.type);
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementId, outputStream);
        byteLen += ReadWriteIOUtils.write(this.type, outputStream);
        byteLen += ReadWriteIOUtils.write(this.encoding, outputStream);
        byteLen += ReadWriteIOUtils.write(this.compressor, outputStream);
        if (this.props == null) {
            byteLen += ReadWriteIOUtils.write(0, outputStream);
        } else {
            byteLen += ReadWriteIOUtils.write(this.props.size(), outputStream);
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), outputStream);
            }
        }
        return byteLen;
    }

    public int serializeTo(ByteBuffer buffer) {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.measurementId, buffer);
        byteLen += ReadWriteIOUtils.write(this.type, buffer);
        byteLen += ReadWriteIOUtils.write(this.encoding, buffer);
        byteLen += ReadWriteIOUtils.write(this.compressor, buffer);
        if (this.props == null) {
            byteLen += ReadWriteIOUtils.write(0, buffer);
        } else {
            byteLen += ReadWriteIOUtils.write(this.props.size(), buffer);
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
                byteLen += ReadWriteIOUtils.write(entry.getValue(), buffer);
            }
        }
        return byteLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeasurementSchema that = (MeasurementSchema)o;
        return this.type == that.type && this.encoding == that.encoding && Objects.equals(this.measurementId, that.measurementId) && Objects.equals(this.encodingConverter, that.encodingConverter) && Objects.equals((Object)this.compressor, (Object)that.compressor) && Objects.equals(this.props, that.props);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.encoding, this.measurementId, this.encodingConverter, this.compressor, this.props});
    }

    @Override
    public int compareTo(MeasurementSchema o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.measurementId.compareTo(o.measurementId);
    }

    public String toString() {
        StringContainer sc = new StringContainer("");
        sc.addTail("[", this.measurementId, ",", this.type.toString(), ",", this.encoding.toString(), ",", this.props.toString(), ",", this.compressor.toString());
        sc.addTail("]");
        return sc.toString();
    }
}

