/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class FileSchema {
    private Map<String, MeasurementSchema> measurementSchema = new HashMap<String, MeasurementSchema>();

    public FileSchema() {
    }

    public FileSchema(Map<String, MeasurementSchema> measurements) {
        this();
        this.registerMeasurements(measurements);
    }

    public TSDataType getMeasurementDataType(String measurementId) {
        MeasurementSchema mSchema = this.measurementSchema.get(measurementId);
        if (mSchema == null) {
            return null;
        }
        return mSchema.getType();
    }

    public MeasurementSchema getMeasurementSchema(String measurementId) {
        return this.measurementSchema.get(measurementId);
    }

    public Map<String, MeasurementSchema> getAllMeasurementSchema() {
        return this.measurementSchema;
    }

    public void registerMeasurement(MeasurementSchema descriptor) {
        this.measurementSchema.put(descriptor.getMeasurementId(), descriptor);
    }

    public void registerMeasurements(Map<String, MeasurementSchema> measurements) {
        measurements.forEach((id, md) -> this.registerMeasurement((MeasurementSchema)md));
    }

    public boolean hasMeasurement(String measurementId) {
        return this.measurementSchema.containsKey(measurementId);
    }
}

