/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.write.chunk;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.chunk.ChunkBuffer;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.page.PageWriter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkWriterImpl
implements IChunkWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkWriterImpl.class);
    private static final int MINIMUM_RECORD_COUNT_FOR_CHECK = 1500;
    private final TSDataType dataType;
    private final ChunkBuffer chunkBuffer;
    private final long psThres;
    private final int pageCountUpperBound;
    private PageWriter dataPageWriter;
    private int valueCountInOnePage;
    private int valueCountInOnePageForNextCheck;
    private Statistics<?> pageStatistics;
    private Statistics<?> chunkStatistics;
    private long time;
    private long minTimestamp = -1L;
    private MeasurementSchema measurementSchema;

    public ChunkWriterImpl(MeasurementSchema measurementSchema, ChunkBuffer chunkBuffer, int pageSizeThreshold) {
        this.measurementSchema = measurementSchema;
        this.dataType = measurementSchema.getType();
        this.chunkBuffer = chunkBuffer;
        this.psThres = pageSizeThreshold;
        this.valueCountInOnePageForNextCheck = 1500;
        this.chunkStatistics = Statistics.getStatsByType(this.dataType);
        this.resetPageStatistics();
        this.dataPageWriter = new PageWriter();
        this.pageCountUpperBound = TSFileConfig.maxNumberOfPointsInPage;
        this.dataPageWriter.setTimeEncoder(measurementSchema.getTimeEncoder());
        this.dataPageWriter.setValueEncoder(measurementSchema.getValueEncoder());
    }

    private void resetPageStatistics() {
        this.pageStatistics = Statistics.getStatsByType(this.dataType);
    }

    @Override
    public void write(long time, long value) {
        this.time = time;
        ++this.valueCountInOnePage;
        this.dataPageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == -1L) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, int value) {
        this.time = time;
        ++this.valueCountInOnePage;
        this.dataPageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == -1L) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, boolean value) {
        this.time = time;
        ++this.valueCountInOnePage;
        this.dataPageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == -1L) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, float value) {
        this.time = time;
        ++this.valueCountInOnePage;
        this.dataPageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == -1L) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, double value) {
        this.time = time;
        ++this.valueCountInOnePage;
        this.dataPageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == -1L) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, BigDecimal value) {
        this.time = time;
        ++this.valueCountInOnePage;
        this.dataPageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == -1L) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    @Override
    public void write(long time, Binary value) {
        this.time = time;
        ++this.valueCountInOnePage;
        this.dataPageWriter.write(time, value);
        this.pageStatistics.updateStats(value);
        if (this.minTimestamp == -1L) {
            this.minTimestamp = time;
        }
        this.checkPageSizeAndMayOpenANewPage();
    }

    private void checkPageSizeAndMayOpenANewPage() {
        if (this.valueCountInOnePage == this.pageCountUpperBound) {
            LOG.debug("current line count reaches the upper bound, write page {}", (Object)this.measurementSchema);
            this.writePage();
        } else if (this.valueCountInOnePage >= this.valueCountInOnePageForNextCheck) {
            long currentColumnSize = this.dataPageWriter.estimateMaxMemSize();
            if (currentColumnSize > this.psThres) {
                LOG.debug("enough size, write page {}, psThres:{}, currentColumnSize:{}, valueCountInOnePage:{}", new Object[]{this.measurementSchema.getMeasurementId(), this.psThres, currentColumnSize, this.valueCountInOnePage});
                this.writePage();
                this.valueCountInOnePageForNextCheck = 1500;
            } else {
                this.valueCountInOnePageForNextCheck = (int)((float)this.psThres / (float)currentColumnSize * (float)this.valueCountInOnePage);
                LOG.debug("not enough size. {}, psThres:{}, currentColumnSize:{},  now valueCountInOnePage: {}, change to {}", new Object[]{this.measurementSchema.getMeasurementId(), this.psThres, currentColumnSize, this.valueCountInOnePage, this.valueCountInOnePageForNextCheck});
            }
        }
    }

    private void writePage() {
        try {
            this.chunkBuffer.writePageHeaderAndDataIntoBuff(this.dataPageWriter.getUncompressedBytes(), this.valueCountInOnePage, this.pageStatistics, this.time, this.minTimestamp);
            this.chunkStatistics.mergeStatistics(this.pageStatistics);
        }
        catch (IOException e) {
            LOG.error("meet error in dataPageWriter.getUncompressedBytes(),ignore this page:", (Throwable)e);
        }
        catch (PageException e) {
            LOG.error("meet error in chunkBuffer.writePageHeaderAndDataIntoBuff, ignore this page:", (Throwable)e);
        }
        finally {
            this.minTimestamp = -1L;
            this.valueCountInOnePage = 0;
            this.dataPageWriter.reset();
            this.resetPageStatistics();
        }
    }

    @Override
    public void writeToFileWriter(TsFileIOWriter tsfileWriter) throws IOException {
        this.sealCurrentPage();
        this.chunkBuffer.writeAllPagesOfSeriesToTsFile(tsfileWriter, this.chunkStatistics);
        this.chunkBuffer.reset();
        this.chunkStatistics = Statistics.getStatsByType(this.dataType);
    }

    @Override
    public long estimateMaxSeriesMemSize() {
        return this.dataPageWriter.estimateMaxMemSize() + this.chunkBuffer.estimateMaxPageMemSize();
    }

    @Override
    public long getCurrentChunkSize() {
        return (long)ChunkHeader.getSerializedSize(this.measurementSchema.getMeasurementId()) + this.chunkBuffer.getCurrentDataSize();
    }

    @Override
    public void sealCurrentPage() {
        if (this.valueCountInOnePage > 0) {
            this.writePage();
        }
    }

    @Override
    public int getNumOfPages() {
        return this.chunkBuffer.getNumOfPages();
    }

    public ChunkBuffer getChunkBuffer() {
        return this.chunkBuffer;
    }
}

