/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.timegenerator.node;

import java.io.IOException;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.NodeType;

public class OrNode
implements Node {
    private Node leftChild;
    private Node rightChild;
    private boolean hasCachedLeftValue;
    private long cachedLeftValue;
    private boolean hasCachedRightValue;
    private long cachedRightValue;

    public OrNode(Node leftChild, Node rightChild) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.hasCachedLeftValue = false;
        this.hasCachedRightValue = false;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.hasCachedLeftValue || this.hasCachedRightValue) {
            return true;
        }
        return this.leftChild.hasNext() || this.rightChild.hasNext();
    }

    private boolean hasLeftValue() throws IOException {
        return this.hasCachedLeftValue || this.leftChild.hasNext();
    }

    private long getLeftValue() throws IOException {
        if (this.hasCachedLeftValue) {
            this.hasCachedLeftValue = false;
            return this.cachedLeftValue;
        }
        return this.leftChild.next();
    }

    private boolean hasRightValue() throws IOException {
        return this.hasCachedRightValue || this.rightChild.hasNext();
    }

    private long getRightValue() throws IOException {
        if (this.hasCachedRightValue) {
            this.hasCachedRightValue = false;
            return this.cachedRightValue;
        }
        return this.rightChild.next();
    }

    @Override
    public long next() throws IOException {
        if (this.hasLeftValue() && !this.hasRightValue()) {
            return this.getLeftValue();
        }
        if (!this.hasLeftValue() && this.hasRightValue()) {
            return this.getRightValue();
        }
        if (this.hasLeftValue() && this.hasRightValue()) {
            long rightValue;
            long leftValue = this.getLeftValue();
            if (leftValue < (rightValue = this.getRightValue())) {
                this.hasCachedRightValue = true;
                this.cachedRightValue = rightValue;
                return leftValue;
            }
            if (leftValue > rightValue) {
                this.hasCachedLeftValue = true;
                this.cachedLeftValue = leftValue;
                return rightValue;
            }
            return leftValue;
        }
        return -1L;
    }

    @Override
    public NodeType getType() {
        return NodeType.OR;
    }
}

