/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.controller;

import java.io.IOException;
import org.apache.iotdb.tsfile.common.cache.LRUCache;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.ChunkLoader;

public class ChunkLoaderImpl
implements ChunkLoader {
    private static final int DEFAULT_CHUNK_CACHE_SIZE = 100000;
    private TsFileSequenceReader reader;
    private LRUCache<ChunkMetaData, Chunk> chunkCache;

    public ChunkLoaderImpl(TsFileSequenceReader fileSequenceReader) {
        this(fileSequenceReader, 100000);
    }

    public ChunkLoaderImpl(TsFileSequenceReader fileSequenceReader, int cacheSize) {
        this.reader = fileSequenceReader;
        this.chunkCache = new LRUCache<ChunkMetaData, Chunk>(cacheSize){

            @Override
            public Chunk loadObjectByKey(ChunkMetaData metaData) throws IOException {
                return ChunkLoaderImpl.this.reader.readMemChunk(metaData);
            }
        };
    }

    @Override
    public Chunk getChunk(ChunkMetaData chunkMetaData) throws IOException {
        Chunk chunk = this.chunkCache.get(chunkMetaData);
        Chunk chunkRet = new Chunk(chunk.getHeader(), chunk.getData().duplicate());
        chunkRet.setDeletedAt(chunkMetaData.getDeletedAt());
        return chunkRet;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

