/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common;

import java.io.Serializable;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class Path
implements Serializable {
    private static final long serialVersionUID = 3405277066329298200L;
    private String measurement = null;
    private String device = null;
    private String fullPath;
    private String illegalPathArgument = "Path parameter is null";

    public Path(StringContainer pathSc) {
        if (pathSc == null) {
            throw new IllegalArgumentException("input pathSc is null!");
        }
        String[] splits = pathSc.toString().split("\\.");
        this.init(splits);
    }

    public Path(String pathSc) {
        if (pathSc == null) {
            throw new IllegalArgumentException(this.illegalPathArgument);
        }
        String[] splits = pathSc.split("\\.");
        this.init(splits);
    }

    public Path(String[] pathSc) {
        if (pathSc == null) {
            throw new IllegalArgumentException(this.illegalPathArgument);
        }
        String[] splits = new StringContainer(pathSc, ".").toString().split("\\.");
        this.init(splits);
    }

    public Path(String device, String measurement) {
        if (device == null || measurement == null) {
            throw new IllegalArgumentException(this.illegalPathArgument);
        }
        this.device = device;
        this.measurement = measurement;
        this.fullPath = device + "." + measurement;
    }

    public static Path mergePath(Path prefix, Path suffix) {
        StringContainer sc = new StringContainer(".");
        sc.addTail(prefix);
        sc.addTail(suffix);
        return new Path(sc);
    }

    public static Path addPrefixPath(Path src, String prefix) {
        StringContainer sc = new StringContainer(".");
        sc.addTail(prefix);
        sc.addTail(src);
        return new Path(sc);
    }

    public static Path addPrefixPath(Path src, Path prefix) {
        return Path.addPrefixPath(src, prefix.fullPath);
    }

    public static Path replace(String srcPrefix, Path descPrefix) {
        if ("".equals(srcPrefix) || descPrefix.startWith(srcPrefix)) {
            return descPrefix;
        }
        int prefixSize = srcPrefix.split("\\.").length;
        String[] descArray = descPrefix.fullPath.split("\\.");
        if (descArray.length <= prefixSize) {
            return new Path(srcPrefix);
        }
        StringContainer sc = new StringContainer(".");
        sc.addTail(srcPrefix);
        for (int i = prefixSize; i < descArray.length; ++i) {
            sc.addTail(descArray[i]);
        }
        return new Path(sc);
    }

    public static Path replace(Path srcPrefix, Path descPrefix) {
        return Path.replace(srcPrefix.fullPath, descPrefix);
    }

    private void init(String[] splitedPathArray) {
        StringContainer sc = new StringContainer(splitedPathArray, ".");
        if (sc.size() <= 1) {
            this.device = "";
            this.fullPath = this.measurement = sc.toString();
        } else {
            this.device = sc.getSubStringContainer(0, -2).toString();
            this.measurement = sc.getSubString(-1);
            this.fullPath = sc.toString();
        }
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getDevice() {
        return this.device;
    }

    public String getMeasurement() {
        return this.measurement;
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Path && this.fullPath.equals(((Path)obj).fullPath);
    }

    public boolean equals(String obj) {
        return obj != null && this.fullPath.equals(obj);
    }

    public String toString() {
        return this.fullPath;
    }

    public Path clone() {
        return new Path(this.fullPath);
    }

    public boolean startWith(String prefix) {
        return prefix != null && this.fullPath.startsWith(prefix);
    }

    public boolean startWith(Path prefix) {
        return this.startWith(prefix.fullPath);
    }
}

